#
# xmlcomposer.pl
#
# programmed by yamataka 2006/07/15
#
use strict;
use XML::Parser;

main();
exit(0);
#-----------------------------------------------------------

sub main {
	my $filename = $ARGV[0];
	if (1 != @ARGV) {
		print "usage: command <file>\n";
		exit(0);
	}
	my $composer = new XMLComposer($filename, 1);
	$composer->parse();
	
	print $composer->getContent(). "\n";
}

#-----------------------------------------------------------
package XMLComposer;

sub new {
	my ($pkg, $current_filename, $use_XMLDecl_Doctype) = @_;
	if (!-e $current_filename) {
		if (0 >= length($current_filename)) {
			die "file not exist.\n";
		} eles {
			die $current_filename. " not exist";
		}
	}

	# lock
	my $lockfile = $current_filename. "_locked";
	if (!mkdir($lockfile, 0755)) {
		return;
	}

	my $xml_parser = new XML::Parser(Namespaces => 1);
	bless {
		current_filename => $current_filename,
		lockfile => $lockfile,
		xml_parser => $xml_parser,
		out_content => "",
		use_XMLDecl_Doctype => $use_XMLDecl_Doctype,
	}, $pkg;
}

sub DESTROY {
	my ($pkg) = @_;
	# unlock
	rmdir($pkg->{lockfile});
}

sub getContent {
	my ($self) = @_;
	return $self->{out_content};
}

sub init {
	my ($self) = @_;
	my $xmldecl = undef;
	my $doctype = undef;
	if ($self->{use_XMLDecl_Doctype}) {
		$xmldecl = sub { $self->{out_content} .= $self->handleXMLDecl(@_) };
		$doctype = sub { $self->{out_content} .= $self->handleDoctype(@_) };
	}
	$self->{xml_parser}->setHandlers(
		Start => sub { $self->{out_content} .= $self->handleStartElement(@_) },
		Char => sub { $self->{out_content} .= $self->handleCharacters(@_) },
		End => sub { $self->{out_content} .= $self->handleEndElement(@_) },
		Comment => sub { $self->{out_content} .= $self->handleComment(@_) },

		XMLDecl => $xmldecl,
		Doctype => $doctype,
		);
}

sub parse {
	my ($self) = @_;
	$self->init();
	$self->{xml_parser}->parsefile($self->{current_filename});
}

sub isXMLComposerElement {
	my ($self, $parser, $element, @attrs) = @_;
	my $xmlcomposer_uri = "http://example.com/xmlcomposer";
	return $parser->namespace($element) eq $xmlcomposer_uri;
}

sub handleXMLDecl {
	my ($self, $parser, $version, $encoding, $standalone) = @_;
	if ($version ne "" && $version ne "1.0") {
		die $self->{current_filename}. " is XML ". $version. ". ".
			"This program accepts XML 1.0 only.\n";
	}
	
	my $str = '<?xml';
	$str .= ' version="'. $version. '"';
	$str .= ' encoding="UTF-8"';
	if ($standalone) {
		$str .= ' standalone="'. $standalone. '"';
	}
	$str .= "?>\n";
	return $str;
	#return $parser->original_string. "\n";
}

sub handleDoctype {
	my ($self, $parser, $name, $sysid, $pubid, $internal) = @_;
	my $str = '<!DOCTYPE '. $name.
		' PUBLIC "'. $pubid. '"'.
		' "'. $sysid. '">'. "\n\n";
	return $str;
}

sub handleStartElement {
	my ($self, $parser, $element, @attrs) = @_;
	if (isXMLComposerElement(@_)) {
		if ($element eq "include") {
			my %attrs = @attrs;
			my $filename = $attrs{'file'};
			my $composer = new XMLComposer($filename);
			if (not defined $composer) {
				die "recursive-include error at ".
					$self->{current_filename}.
					" line ". $parser->current_line.  ".\n";
			}
			$composer->parse();
			return $composer->getContent();
		} else {
			die $element. " is unknown element at ".
				$self->{current_filename}.
				" line ". $parser->current_line.  ".\n";
		}
	}
	return $parser->recognized_string;
}

sub handleEndElement {
	my ($self, $parser, $element, @attrs) = @_;
	return $parser->recognized_string;
}

sub handleCharacters {
	shift;
	shift;
	my ($chars) = @_;
	return $chars;
}

sub handleComment {
	shift;
	my ($parser, $comment) = @_;
	my $str = '<!--'.
		$comment.
		'-->';
	return $str;
}
# end of package XMLComposer
#-----------------------------------------------------------
