#!/usr/bin/python
# -*- coding: utf-8 -*- 

#
# Copyright (C) 2006 BEE Co.,Ltd.
#
# Author : Fukasawa Mitsuo
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
#

import os, shutil, sys, getopt
import datetime, time
import srgs
import unittest
from test import test_support
from xml.dom.minidom import parse, parseString

#
def remake_rule_list(x):
    # to line of words
    t = {}
    wordq = 0
    p1 = 0
    p2 = x.find('] ', p1)
    while p2 != -1 and len(x[p1:p2+1]) > 0:
        t[wordq] = x[p1:p2+1]
        p1 = p2 + 2
        p2 = x.find('] ', p1)
        wordq += 1
    #print "word count = " + str(wordq)
    if wordq == 0:
        s = x.split('[')
        n = 0
        z = ""
        while n < len(z) - 1:   # remake external rule
            if s[n].find('#') >= 0:
                y = s[n][0] + '<' + s[n][1:] + '>'
                s[n] = y
            z += s[n] + '['
            n += 1
        z += s[n]
        #print z
        return z
    #
    # to rule name and word
    words = {}
    i = 0
    while i < wordq:
        s = t[i].split('[')
        n = 0
        while n < len(s) - 1:   # remake external rule
            if s[n].find('#') >= 0:
                y = s[n][0] + '<' + s[n][1:] + '>'
                s[n] = y
            n += 1
        j = s[len(s) - 1].strip(']')
        s[len(s) - 1] = j
        words[i] = s
        # print(s)
        i += 1
    #
    # remake calling rule list
    i = 0
    result = ""
    n = 0
    while i < wordq:
        if i > 0:
            result += ','
        while n < len(words[i]) - 1:
            result += words[i][n] + '['
            n += 1
        result += words[i][n]
        j = 0
        if i < wordq - 1:
            while j < len(words[i+1]):
                if words[i][j] != words[i+1][j]:
                    break
                j += 1
            #
        k = 0
        while k < (len(words[i]) - j - 1):
            result += ']'
            k += 1
        n = j
        i += 1
    #
    return result

#
class SrgsTest:
    def __init__(self, name, content):
        self.name = name
        self.content = content
        self.expect = ""

    def setExpect(self, expect):
        self.expect = expect

    def judge(self, result):
        return self.expect == result

#
def srgsTestFunction(self, file):
    result = True
    tests = {}

    srgsfp = open(file, "r")
    dom = parse(srgsfp) # parse an open file
    meta = dom.getElementsByTagName("meta")
    for i in meta:
        #print i.getAttribute("name")
        attr = i.getAttribute("name")
        content = i.getAttribute("content")
        p = attr.split('.')
        if p[0] == "in":
            tests[int(p[1])-1] = SrgsTest("test" + p[1], content)
        elif p[0] == "out":
            tests[int(p[1])-1].setExpect(content)
        else:
            pass
    #
    dom.unlink()
    srgsfp.close()

    # parse srgs file
    a = srgs.make_dictionary(file)
    # evaluate
    t = 0
    while t < len(tests):
        #print tests[t].name + ":" + tests[t].content + "," + tests[t].expect
        w = a.recognize(str(tests[t].content))
        #print(w)
        x = remake_rule_list(w)
        if x != tests[t].expect:
            result = False
        t += 1

    if result:
        msg = file + " is ok"
    else:
        msg = file + " is ng: " + x
    return result, msg

#
class SrgsTestCase(unittest.TestCase):
    func = srgsTestFunction

    def setUp(self):
        srgs.init()
        pass

    #def tearDown(self):
    #    ... code to execute to clean up after tests ...

    def test_func(self):
        result = self.func(self.file)
        self.assert_(result[0], result[1])


class TestCase_simple(SrgsTestCase):
    file = 'simple.grxml'

class TestCase_alternative_null(SrgsTestCase):
    file = 'alternative-null.grxml'

class TestCase_alternative_one_item(SrgsTestCase):
    file = 'alternative-one-item.grxml'

class TestCase_alternative_one_tag(SrgsTestCase):
    file = 'alternative-one-tag.grxml'

class TestCase_alternatives_all_weights(SrgsTestCase):
    file = 'alternatives-all-weights.grxml'

class TestCase_(SrgsTestCase):
    file = 'alternatives-no-weights.grxml'

class TestCase_alternatives_one_no_weight(SrgsTestCase):
    file = 'alternatives-one-no-weight.grxml'

class TestCase_alternatives_one_with_weight(SrgsTestCase):
    file = 'alternatives-one-with-weight.grxml'

class TestCase_alternatives_some_weights(SrgsTestCase):
    file = 'alternatives-some-weights.grxml'

class TestCase_base_declaration(SrgsTestCase):
    file = 'base-declaration.grxml'

class TestCase_base_metabase(SrgsTestCase):
    file = 'base-metabase.grxml'

class TestCase_comment_xml(SrgsTestCase):
    file = 'comment-xml.grxml'

class TestCase_common(SrgsTestCase):
    file = 'common.grxml'

class TestCase_conformance_1(SrgsTestCase):
    file = 'conformance-1.grxml'

class TestCase_conformance_2(SrgsTestCase):
    file = 'conformance-2.grxml'

class TestCase_conformance_3(SrgsTestCase):
    file = 'conformance-3.grxml'

class TestCase_conformance_4(SrgsTestCase):
    file = 'conformance-4.grxml'

class TestCase_conformance_5(SrgsTestCase):
    file = 'conformance-5.grxml'

class TestCase_conformance_6(SrgsTestCase):
    file = 'conformance-6.grxml'

class TestCase_conformance_7(SrgsTestCase):
    file = 'conformance-7.grxml'

class TestCase_doctype(SrgsTestCase):
    file = 'doctype.grxml'

class TestCase_dtmf_full(SrgsTestCase):
    file = 'dtmf-full.grxml'

class TestCase_dtmf_pound_star(SrgsTestCase):
    file = 'dtmf-pound-star.grxml'

class TestCase_dtmf_sequence(SrgsTestCase):
    file = 'dtmf-sequence.grxml'

class TestCase_dtmf_simple(SrgsTestCase):
    file = 'dtmf-simple.grxml'

class TestCase_duplicated_rulenames(SrgsTestCase):
    file = 'duplicated-rulenames.grxml'

class TestCase_duplicated_special_rulenames(SrgsTestCase):
    file = 'duplicated-special-rulenames.grxml'

class TestCase_english_names(SrgsTestCase):
    file = 'english_names.grxml'

class TestCase_example_1(SrgsTestCase):
    file = 'example-1.grxml'

class TestCase_example_2_booking(SrgsTestCase):
    file = 'example-2-booking.grxml'

class TestCase_example_2_places(SrgsTestCase):
    file = 'example-2-places.grxml'

class TestCase_example_3_korean_yesno_unicode(SrgsTestCase):
    file = 'example-3-korean-yesno-unicode.grxml'

class TestCase_example_3_korean_yesno_utf8(SrgsTestCase):
    file = 'example-3-korean-yesno-utf8.grxml'

class TestCase_example_4_chinese_digits_unicode(SrgsTestCase):
    file = 'example-4-chinese-digits-unicode.grxml'

class TestCase_example_4_chinese_digits_utf8(SrgsTestCase):
    file = 'example-4-chinese-digits-utf8.grxml'

class TestCase_example_5_swedish_boolean(SrgsTestCase):
    file = 'example-5-swedish-boolean.grxml'

class TestCase_example(SrgsTestCase):
    file = 'example.grxml'

class TestCase_french_names(SrgsTestCase):
    file = 'french_names.grxml'

class TestCase_header_encoding_none(SrgsTestCase):
    file = 'header-encoding-none.grxml'

class TestCase_korean_yesno_utf16_be(SrgsTestCase):
    file = 'korean-yesno-utf16-be.grxml'

class TestCase_korean_yesno_utf16_le(SrgsTestCase):
    file = 'korean-yesno-utf16-le.grxml'

class TestCase_korean_yesno_utf8(SrgsTestCase):
    file = 'korean-yesno-utf8.grxml'

class TestCase_lang_ruleref(SrgsTestCase):
    file = 'lang-ruleref.grxml'

class TestCase_lang_sequence(SrgsTestCase):
    file = 'lang-sequence.grxml'

class TestCase_language_dtmf_ignore(SrgsTestCase):
    file = 'language-dtmf-ignore.grxml'

class TestCase_language_en_us(SrgsTestCase):
    file = 'language-en-us.grxml'

class TestCase_language_missing(SrgsTestCase):
    file = 'language-missing.grxml'

class TestCase_language_other(SrgsTestCase):
    file = 'language-other.grxml'

class TestCase_lexicon_many(SrgsTestCase):
    file = 'lexicon-many.grxml'

class TestCase_lexicon_none(SrgsTestCase):
    file = 'lexicon-none.grxml'

class TestCase_lexicon_one(SrgsTestCase):
    file = 'lexicon-one.grxml'

class TestCase_meta_http(SrgsTestCase):
    file = 'meta-http.grxml'

class TestCase_meta(SrgsTestCase):
    file = 'meta.grxml'

class TestCase_metabase_declaration(SrgsTestCase):
    file = 'metabase-declaration.grxml'

class TestCase_mode_dtmf(SrgsTestCase):
    file = 'mode-dtmf.grxml'

class TestCase_mode_none(SrgsTestCase):
    file = 'mode-none.grxml'

class TestCase_mode_voice(SrgsTestCase):
    file = 'mode-voice.grxml'

class TestCase_more_english_names(SrgsTestCase):
    file = 'more_english_names.grxml'

class TestCase_no_doctype(SrgsTestCase):
    file = 'no-doctype.grxml'

class TestCase_no_language_no_mode(SrgsTestCase):
    file = 'no-language-no-mode.grxml'

class TestCase_no_namespace(SrgsTestCase):
    file = 'no-namespace.grxml'

class TestCase_no_rules(SrgsTestCase):
    file = 'no-rules.grxml'

class TestCase_no_version(SrgsTestCase):
    file = 'no-version.grxml'

class TestCase_polite(SrgsTestCase):
    file = 'polite.grxml'

class TestCase_politeness(SrgsTestCase):
    file = 'politeness.grxml'

class TestCase_rdf_metadata(SrgsTestCase):
    file = 'rdf-metadata.grxml'

class TestCase_recursion(SrgsTestCase):
    file = 'recursion.grxml'

class TestCase_repeat_0_times(SrgsTestCase):
    file = 'repeat-0-times.grxml'

class TestCase_repeat_m_n_times(SrgsTestCase):
    file = 'repeat-m-n-times.grxml'

class TestCase_(SrgsTestCase):
    file = 'repeat-m-or-more.grxml'

class TestCase_repeat_many_null(SrgsTestCase):
    file = 'repeat-many-null.grxml'

class TestCase_(SrgsTestCase):
    file = 'repeat-n-exact.grxml'

class TestCase_repeat_optional_void(SrgsTestCase):
    file = 'repeat-optional-void.grxml'

class TestCase_repeat_optional(SrgsTestCase):
    file = 'repeat-optional.grxml'

class TestCase_repeat_with_probs(SrgsTestCase):
    file = 'repeat-with-probs.grxml'

class TestCase_root_rule_decl_missing(SrgsTestCase):
    file = 'root-rule-decl-missing.grxml'

class TestCase_root_rule_decl(SrgsTestCase):
    file = 'root-rule-decl.grxml'

class TestCase_rule_basic_def(SrgsTestCase):
    file = 'rule-basic-def.grxml'

class TestCase_rule_empty_item(SrgsTestCase):
    file = 'rule-empty-item.grxml'

class TestCase_rule_no_empty(SrgsTestCase):
    file = 'rule-no-empty.grxml'

class TestCase_rule_null(SrgsTestCase):
    file = 'rule-null.grxml'

class TestCase_rule_private(SrgsTestCase):
    file = 'rule-private.grxml'

class TestCase_rule_public(SrgsTestCase):
    file = 'rule-public.grxml'

class TestCase_rule_tag(SrgsTestCase):
    file = 'rule-tag.grxml'

class TestCase_ruleref_ext_private_root(SrgsTestCase):
    file = 'ruleref-ext-private-root.grxml'

class TestCase_ruleref_ext_private_rule(SrgsTestCase):
    file = 'ruleref-ext-private-rule.grxml'

class TestCase_ruleref_ext_root_mediatype(SrgsTestCase):
    file = 'ruleref-ext-root-mediatype.grxml'

class TestCase_ruleref_ext_root(SrgsTestCase):
    file = 'ruleref-ext-root.grxml'

class TestCase_ruleref_ext_rule_mediatype(SrgsTestCase):
    file = 'ruleref-ext-rule-mediatype.grxml'

class TestCase_ruleref_ext_rule(SrgsTestCase):
    file = 'ruleref-ext-rule.grxml'

class TestCase_ruleref_local(SrgsTestCase):
    file = 'ruleref-local.grxml'

class TestCase_ruleref_mismatch_mediatype(SrgsTestCase):
    file = 'ruleref-mismatch-mediatype.grxml'

class TestCase_ruleref_mismatch_modes(SrgsTestCase):
    file = 'ruleref-mismatch-modes.grxml'

class TestCase_ruleref_nonexistent_local(SrgsTestCase):
    file = 'ruleref-nonexistent-local.grxml'

class TestCase_sequence_item_empty(SrgsTestCase):
    file = 'sequence-item-empty.grxml'

class TestCase_sequence_item_whitespace(SrgsTestCase):
    file = 'sequence-item-whitespace.grxml'

class TestCase_sequence_ruleref_token(SrgsTestCase):
    file = 'sequence-ruleref-token.grxml'

class TestCase_sequence_ruleref(SrgsTestCase):
    file = 'sequence-ruleref.grxml'

class TestCase_sequence_token(SrgsTestCase):
    file = 'sequence-token.grxml'

class TestCase_special_garbage(SrgsTestCase):
    file = 'special-garbage.grxml'

class TestCase_special_null(SrgsTestCase):
    file = 'special-null.grxml'

class TestCase_special_void(SrgsTestCase):
    file = 'special-void.grxml'

class TestCase_tag_format_decl_missing(SrgsTestCase):
    file = 'tag-format-decl-missing.grxml'

class TestCase_tag_format_decl(SrgsTestCase):
    file = 'tag-format-decl.grxml'

class TestCase_tag_many(SrgsTestCase):
    file = 'tag-many.grxml'

class TestCase_tag_repetition(SrgsTestCase):
    file = 'tag-repetition.grxml'

class TestCase_tag_standalone(SrgsTestCase):
    file = 'tag-standalone.grxml'

class TestCase_token_basic(SrgsTestCase):
    file = 'token-basic.grxml'

class TestCase_token_element(SrgsTestCase):
    file = 'token-element.grxml'

class TestCase_token_quoted(SrgsTestCase):
    file = 'token-quoted.grxml'

class TestCase_token_unicode(SrgsTestCase):
    file = 'token-unicode.grxml'

class TestCase_undefined_root(SrgsTestCase):
    file = 'undefined-root.grxml'

class TestCase_uri_ref_undefined_root_referenced(SrgsTestCase):
    file = 'uri-ref-undefined-root-referenced.grxml'

class TestCase_uri_ref_undefined_root_referring(SrgsTestCase):
    file = 'uri-ref-undefined-root-referring.grxml'

class TestCase_xml_lang_item_single_lang(SrgsTestCase):
    file = 'xml_lang-item-single-lang.grxml'

class TestCase_xml_lang_one_of_single_lang(SrgsTestCase):
    file = 'xml_lang-one-of-single-lang.grxml'

class TestCase_xml_lang_token_single_lang(SrgsTestCase):
    file = 'xml_lang-token-single-lang.grxml'


def test_main():
    test_support.run_unittest(
                              TestCase_simple,
                              TestCase_alternative_null,
                              TestCase_alternative_one_item,
                              TestCase_alternative_one_tag,
                              # TestCase_alternatives_all_weights,
                              TestCase_alternatives_one_no_weight,
                              TestCase_alternatives_one_with_weight,
                              TestCase_alternatives_some_weights,
                              # TestCase_base_declaration,
                              # TestCase_base_metabase,
                              TestCase_comment_xml,
                              ### TestCase_common,
                              # TestCase_conformance_1,
                              # TestCase_conformance_2,
                              # TestCase_conformance_3,
                              # TestCase_conformance_4,
                              # TestCase_conformance_5,
                              # TestCase_conformance_6,
                              # TestCase_conformance_7,
                              TestCase_doctype,
                              # TestCase_dtmf_full,
                              # TestCase_dtmf_pound_star,
                              # TestCase_dtmf_sequence,
                              # TestCase_dtmf_simple,
                              TestCase_duplicated_rulenames,
                              TestCase_duplicated_special_rulenames,
                              ### TestCase_english_names,
                              # TestCase_example_1,
                              # TestCase_example_2_booking,
                              TestCase_example_2_places,
                              ## TestCase_example_3_korean_yesno_unicode,
                              ## TestCase_example_3_korean_yesno_utf8,
                              ## TestCase_example_4_chinese_digits_unicode,
                              ## TestCase_example_4_chinese_digits_utf8,
                              ## TestCase_example_5_swedish_boolean,
                              TestCase_example,
                              ### TestCase_french_names,
                              TestCase_header_encoding_none,
                              ## TestCase_korean_yesno_utf16_be,
                              ## TestCase_korean_yesno_utf16_le,
                              ## TestCase_korean_yesno_utf8,
                              # TestCase_lang_ruleref,
                              # TestCase_lang_sequence,
                              # TestCase_language_dtmf_ignore,
                              # TestCase_language_en_us,
                              # TestCase_language_missing,
                              # TestCase_language_other,
                              TestCase_lexicon_many,
                              TestCase_lexicon_none,
                              TestCase_lexicon_one,
                              TestCase_meta_http,
                              TestCase_meta,
                              # TestCase_metabase_declaration,
                              TestCase_mode_dtmf,
                              TestCase_mode_none,
                              # TestCase_mode_voice,
                              # TestCase_more_english_names,
                              # TestCase_no_doctype,
                              # TestCase_no_language_no_mode,
                              # TestCase_no_namespace,
                              TestCase_no_rules,
                              TestCase_no_version,
                              TestCase_polite,
                              TestCase_politeness,
                              TestCase_rdf_metadata,
                              TestCase_recursion,
                              # TestCase_repeat_0_times,
                              # TestCase_repeat_m_n_times,
                              # TestCase_repeat_many_null,
                              # TestCase_repeat_optional_void,
                              # TestCase_repeat_optional,
                              # TestCase_repeat_with_probs,
                              # TestCase_root_rule_decl_missing,
                              TestCase_root_rule_decl,
                              # TestCase_rule_basic_def,
                              TestCase_rule_empty_item,
                              TestCase_rule_no_empty,
                              TestCase_rule_null,
                              # TestCase_rule_private,
                              # TestCase_rule_public,
                              # TestCase_rule_tag,
                              # TestCase_ruleref_ext_private_root,
                              # TestCase_ruleref_ext_private_rule,
                              # TestCase_ruleref_ext_root_mediatype,
                              # TestCase_ruleref_ext_root,
                              # TestCase_ruleref_ext_rule_mediatype,
                              TestCase_ruleref_ext_rule,
                              # TestCase_ruleref_local,
                              # TestCase_ruleref_mismatch_mediatype,
                              # TestCase_ruleref_mismatch_modes,
                              # TestCase_ruleref_nonexistent_local,
                              TestCase_sequence_item_empty,
                              TestCase_sequence_item_whitespace,
                              # TestCase_sequence_ruleref_token,
                              # TestCase_sequence_ruleref,
                              # TestCase_sequence_token,
                              # TestCase_special_garbage,
                              TestCase_special_null,
                              # TestCase_special_void,
                              # TestCase_tag_format_decl_missing,
                              TestCase_tag_format_decl,
                              # TestCase_tag_many,
                              # TestCase_tag_repetition,
                              # TestCase_tag_standalone,
                              TestCase_token_basic,
                              # TestCase_token_element,
                              # TestCase_token_quoted,
                              # TestCase_token_unicode,
                              TestCase_undefined_root,
                              # TestCase_uri_ref_undefined_root_referenced,
                              # TestCase_uri_ref_undefined_root_referring,
                              TestCase_xml_lang_item_single_lang,
                              # TestCase_xml_lang_one_of_single_lang,
                              TestCase_xml_lang_token_single_lang,
                             )

if __name__ == '__main__':
    test_main()

