/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.internal.observable;

import org.eclipse.jface.internal.databinding.provisional.DataBindingContext;
import org.eclipse.jface.internal.databinding.provisional.description.Property;
import org.eclipse.jface.internal.databinding.provisional.observable.Diffs;
import org.eclipse.jface.internal.databinding.provisional.observable.value.AbstractObservableValue;
import org.eclipse.jface.internal.databinding.provisional.observable.value.IObservableValue;
import org.eclipse.jface.internal.databinding.provisional.observable.value.IValueChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.value.ValueDiff;
import org.eclipse.jface.util.Assert;

public class NestedObservableValue
extends AbstractObservableValue {
    private boolean updating = false;
    private IValueChangeListener innerChangeListener = new IValueChangeListener(){

        public void handleValueChange(IObservableValue source, ValueDiff diff) {
            if (!NestedObservableValue.this.updating) {
                NestedObservableValue.this.fireValueChange(diff);
            }
        }
    };
    private Object currentOuterValue;
    private Object feature;
    private IObservableValue innerObservableValue;
    private DataBindingContext databindingContext;
    private Object featureType;
    private IObservableValue outerObservableValue;
    IValueChangeListener outerChangeListener = new IValueChangeListener(){

        public void handleValueChange(IObservableValue source, ValueDiff diff) {
            Object oldValue = NestedObservableValue.this.doGetValue();
            NestedObservableValue.this.updateInnerObservableValue(NestedObservableValue.this.outerObservableValue);
            NestedObservableValue.this.fireValueChange(Diffs.createValueDiff(oldValue, NestedObservableValue.this.doGetValue()));
        }
    };

    public NestedObservableValue(DataBindingContext databindingContext, IObservableValue outerObservableValue, Object feature, Class featureType) {
        this.databindingContext = databindingContext;
        this.feature = feature;
        this.featureType = featureType;
        this.outerObservableValue = outerObservableValue;
        this.updateInnerObservableValue(outerObservableValue);
        outerObservableValue.addValueChangeListener(this.outerChangeListener);
    }

    private void updateInnerObservableValue(IObservableValue outerObservableValue) {
        this.currentOuterValue = outerObservableValue.getValue();
        if (this.innerObservableValue != null) {
            this.innerObservableValue.removeValueChangeListener(this.innerChangeListener);
            this.innerObservableValue.dispose();
        }
        if (this.currentOuterValue == null) {
            this.innerObservableValue = null;
        } else {
            this.innerObservableValue = (IObservableValue)this.databindingContext.createObservable(new Property(this.currentOuterValue, this.feature));
            Object innerValueType = this.innerObservableValue.getValueType();
            if (this.featureType == null) {
                this.featureType = innerValueType;
            } else {
                Assert.isTrue((boolean)this.featureType.equals(innerValueType), (String)"Cannot change value type in a nested observable value");
            }
            this.innerObservableValue.addValueChangeListener(this.innerChangeListener);
        }
    }

    public void setValue(Object value) {
        if (this.innerObservableValue != null) {
            this.innerObservableValue.setValue(value);
        }
    }

    public Object doGetValue() {
        return this.innerObservableValue == null ? null : this.innerObservableValue.getValue();
    }

    public Object getValueType() {
        return this.featureType;
    }

    public void dispose() {
        super.dispose();
        if (this.outerObservableValue != null) {
            this.outerObservableValue.removeValueChangeListener(this.outerChangeListener);
            this.outerObservableValue.dispose();
        }
        if (this.innerObservableValue != null) {
            this.innerObservableValue.removeValueChangeListener(this.innerChangeListener);
            this.innerObservableValue.dispose();
        }
        this.currentOuterValue = null;
        this.databindingContext = null;
        this.feature = null;
        this.innerObservableValue = null;
        this.innerChangeListener = null;
    }
}

