/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.internal.observable;

import java.util.HashSet;
import org.eclipse.jface.internal.databinding.provisional.DataBindingContext;
import org.eclipse.jface.internal.databinding.provisional.description.Property;
import org.eclipse.jface.internal.databinding.provisional.observable.Diffs;
import org.eclipse.jface.internal.databinding.provisional.observable.set.IObservableSet;
import org.eclipse.jface.internal.databinding.provisional.observable.set.ISetChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.set.ObservableSet;
import org.eclipse.jface.internal.databinding.provisional.observable.set.SetDiff;
import org.eclipse.jface.internal.databinding.provisional.observable.value.IObservableValue;
import org.eclipse.jface.internal.databinding.provisional.observable.value.IValueChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.value.ValueDiff;
import org.eclipse.jface.util.Assert;

public class NestedObservableSet
extends ObservableSet {
    private boolean updating = false;
    private ISetChangeListener innerChangeListener = new ISetChangeListener(){

        public void handleSetChange(IObservableSet source, SetDiff diff) {
            if (!NestedObservableSet.this.updating) {
                NestedObservableSet.this.fireSetChange(diff);
            }
        }
    };
    private Object currentOuterValue;
    private Object feature;
    private IObservableSet innerObservableSet;
    private DataBindingContext databindingContext;
    private IObservableValue outerObservableValue;
    IValueChangeListener outerChangeListener = new IValueChangeListener(){

        public void handleValueChange(IObservableValue source, ValueDiff diff) {
            HashSet oldSet = new HashSet(NestedObservableSet.this.wrappedSet);
            NestedObservableSet.this.updateInnerObservableValue(NestedObservableSet.this.outerObservableValue);
            NestedObservableSet.this.fireSetChange(Diffs.computeSetDiff(oldSet, NestedObservableSet.this.wrappedSet));
        }
    };

    public NestedObservableSet(DataBindingContext databindingContext, IObservableValue outerObservableValue, Object feature, Object featureType) {
        super(new HashSet(), featureType);
        this.databindingContext = databindingContext;
        this.feature = feature;
        this.outerObservableValue = outerObservableValue;
        this.updateInnerObservableValue(outerObservableValue);
        outerObservableValue.addValueChangeListener(this.outerChangeListener);
    }

    private void updateInnerObservableValue(IObservableValue outerObservableValue) {
        this.currentOuterValue = outerObservableValue.getValue();
        if (this.innerObservableSet != null) {
            this.innerObservableSet.removeSetChangeListener(this.innerChangeListener);
            this.innerObservableSet.dispose();
        }
        if (this.currentOuterValue == null) {
            this.innerObservableSet = null;
            this.wrappedSet = new HashSet();
        } else {
            this.innerObservableSet = (IObservableSet)this.databindingContext.createObservable(new Property(this.currentOuterValue, this.feature));
            this.wrappedSet = this.innerObservableSet;
            Object innerValueType = this.innerObservableSet.getElementType();
            if (this.elementType == null) {
                this.elementType = innerValueType;
            } else {
                Assert.isTrue((boolean)this.elementType.equals(innerValueType), (String)"Cannot change value type in a nested updatable value");
            }
            this.innerObservableSet.addSetChangeListener(this.innerChangeListener);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.outerObservableValue != null) {
            this.outerObservableValue.removeValueChangeListener(this.outerChangeListener);
            this.outerObservableValue.dispose();
        }
        if (this.innerObservableSet != null) {
            this.innerObservableSet.removeSetChangeListener(this.innerChangeListener);
            this.innerObservableSet.dispose();
        }
        this.currentOuterValue = null;
        this.databindingContext = null;
        this.feature = null;
        this.innerObservableSet = null;
        this.innerChangeListener = null;
    }
}

