/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.libconcierge;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jp.sourceforge.libconcierge.ZipData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    private static final int EOF = -1;

    public static void copy(String src, String dest) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(src);
            out = new FileOutputStream(dest);
            FileChannel cIn = in.getChannel();
            FileChannel cOut = out.getChannel();
            cIn.transferTo(0L, cIn.size(), cOut);
        }
        catch (Throwable throwable) {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static String getFilename(String filepath) {
        String[] components = filepath.split("\\" + File.separator);
        String filename = components[components.length - 1];
        return filename;
    }

    public static String getDirectory(String filepath) {
        String separator = File.separator;
        String[] names = filepath.split("\\" + separator);
        String directory = "";
        if (System.getProperty("os.name").contains("Win")) {
            directory = names[0];
            int i = 1;
            while (i < names.length - 1) {
                directory = String.valueOf(directory) + separator + names[i];
                ++i;
            }
        } else {
            int i = 1;
            while (i < names.length - 1) {
                directory = String.valueOf(directory) + separator + names[i];
                ++i;
            }
        }
        return String.valueOf(directory) + separator;
    }

    public static String makeZipFile(String tgtdir, String tmpdir) {
        String message = "";
        ZipOutputStream zos = null;
        try {
            File zipFile = new File(tgtdir);
            zos = new ZipOutputStream(new FileOutputStream(zipFile));
        }
        catch (FileNotFoundException fileNotFoundException) {
            message = String.valueOf(message) + "Failed to create an output stream for zip files.\n";
        }
        ArrayList<ZipData> xmls = FileUtil.getZipDataFromFolder(tmpdir, "");
        int i = 0;
        while (i < xmls.size()) {
            FileUtil.addTargetFile(zos, xmls.get(i));
            ++i;
        }
        try {
            String attachdir = String.valueOf(tmpdir) + "files" + File.separator;
            String prefix = "files" + File.separator;
            xmls = FileUtil.getZipDataFromFolder(attachdir, prefix);
            int i2 = 0;
            while (i2 < xmls.size()) {
                System.out.println("target : [" + xmls.get(i2) + "]");
                FileUtil.addTargetFile(zos, xmls.get(i2));
                ++i2;
            }
            zos.close();
        }
        catch (IOException iOException) {
            message = String.valueOf(message) + "Failed to close the zip output stream for attachment files.\n";
        }
        return message;
    }

    public static ArrayList<ZipData> getZipDataFromFolder(String dirname, String prefix) {
        ArrayList<ZipData> list = new ArrayList<ZipData>();
        File dir = new File(dirname);
        if (dir.isDirectory()) {
            String[] files = dir.list();
            int i = 0;
            while (i < files.length) {
                String fpath = String.valueOf(dirname) + files[i];
                File f = new File(fpath);
                if (f.isFile()) {
                    String entry = String.valueOf(prefix) + files[i];
                    ZipData zd = new ZipData(fpath, entry);
                    list.add(zd);
                }
                ++i;
            }
        }
        return list;
    }

    private static void addTargetFile(ZipOutputStream zos, ZipData zd) {
        try {
            int count;
            File file = new File(zd.filepath);
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            ZipEntry target = new ZipEntry(zd.zipentry);
            zos.putNextEntry(target);
            byte[] buf = new byte[1024];
            while ((count = bis.read(buf, 0, 1024)) != -1) {
                zos.write(buf, 0, count);
            }
            bis.close();
            zos.closeEntry();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deleteAll(String path) {
        File fs = new File(path);
        if (fs.isDirectory()) {
            File[] files = fs.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isFile()) {
                    files[i].delete();
                } else {
                    FileUtil.deleteAll(files[i].getAbsolutePath());
                }
                ++i;
            }
            fs.delete();
        }
    }
}

