package jp.ac.wakhok.tomoharu.csv;

import java.util.Enumeration;
import java.util.NoSuchElementException;

/**
 * 1sCSV`̃f[^͂Aꂼ̍ڂɕNXB
 * CSV`ɑΉ java.util.StringTokenizer ̂悤Ȃ́B
 *
 * @version 1.0.1 (1999.4.6)
 * @author TAMURA Kent <kent@muraoka.info.waseda.ac.jp>
 * @author ANDOH Tomoharu <tomoharu@wakhok.ac.jp>
 */

public class CSVTokenizer implements Enumeration {
	public static final String copyright =
			"Copyright 1997 TAMURA Kent" + "\n" +
			"Copyright 1999 ANDOH Tomoharu";
	private String source;                    // ΏۂƂȂ镶
	private int currentPosition;              // ̓ǂݏoʒu
	private int maxPosition;

	/**
	 * CSV ` line ͂ CSVTokenizer ̃CX^X
	 * 쐬B
	 *
	 * @param line CSV`̕  sR[h܂܂ȂB
	 */
	public CSVTokenizer(String line) {
		source = line;
		currentPosition = 0;
		maxPosition = line.length();
	}

	/**
	 * ̃J}ʒuԂB
	 * J}cĂȂꍇ nextComma() == maxPosition ƂȂB
	 * ܂Ō̍ڂ̏ꍇ nextComma() == maxPosition ƂȂB
	 *
	 * @param ind Jnʒu
	 * @return ̃J}ʒuBJ}Ȃꍇ́A
	 * ̒lƂȂB
	 */
	private int nextComma(int ind) {
		boolean inquote = false;
		while (ind < maxPosition) {
			char ch = source.charAt(ind);
			if (!inquote && ch == ',') {
				break;
			} else if ('"' == ch) {
				inquote = !inquote;       // ""̏OK
			}
			ind ++;
		}
		return ind;
	}

	/**
	 * ܂܂Ă鍀ڂ̐ԂB
	 *
	 * @return ܂܂Ă鍀ڂ̐
	 */
	public int countTokens() {
		int i = 0;
		int ret = 1;
		while ((i = nextComma(i)) < maxPosition) {
			i ++;
			ret ++;
		}
		return ret;
	}

	/**
	 * ̍ڂ̕ԂB
	 *
	 * @return ̍
	 * @exception NoSuchElementException ڂcĂȂƂ
	 */
	public String nextToken() {
		// ">=" ł͖̍ڂ𐳂łȂB
		// ̍ڂiJ}1sIjꍇAO
		// ܂̂ŁB
		if (currentPosition > maxPosition)
			throw new NoSuchElementException(toString()+"#nextToken");

		int st = currentPosition;
		currentPosition = nextComma(currentPosition);

		StringBuffer strb = new StringBuffer();
		while (st < currentPosition) {
			char ch = source.charAt(st++);
			if (ch == '"') {
				// "PƂŌꂽƂ͉Ȃ
				if ((st < currentPosition) && (source.charAt(st) == '"')) {
					strb.append(ch);
					st ++;
				}
			} else {
				strb.append(ch);
			}
		}
		currentPosition ++;
		return new String(strb);
	}

	/**
	 * <code>nextToken</code>\bhƓŁA
	 * ̍ڂ̕ԂB<br>
	 * ԒĺAString^ł͂ȂAObject^łB<br>
	 * java.util.EnumerationĂ邽߁Ã\bh
	 * B
	 *
	 * @return ̍
	 * @exception NoSuchElementException ڂcĂȂƂ
	 * @see java.util.Enumeration
	 * @see jp.ac.wakhok.tomoharu.csv.CSVTokenizer#nextElement()
	 */
	public Object nextElement() {
		return nextToken();
	}

	/**
	 * ܂ڂcĂ邩ǂׂB
	 *
	 * @return ܂ڂ̂ĂȂtrue
	 */
	public boolean hasMoreTokens() {
		// "<=" łȂA"<" Ɩ̍ڂ𐳂łȂB
		return (nextComma(currentPosition) <= maxPosition);
	}

	/**
	 * <code>hasMoreTokens</code>\bhƓŁA
	 * ܂ڂcĂ邩ǂׂB<br>
	 * java.util.EnumerationĂ邽߁Ã\bh
	 * B
	 *
	 * @return ܂ڂ̂ĂȂtrue
	 * @see java.util.Enumeration
	 * @see jp.ac.wakhok.tomoharu.csv.CSVTokenizer#hasMoreTokens()
	 */
    public boolean hasMoreElements() {
		return hasMoreTokens();
    }

	/**
	 * CX^X̕\ԂB
	 *
	 * @return CX^X̕\B
	 */
	public String toString() {
		return "CSVTokenizer(\""+source+"\")";
	}
}
