package jp.sourceforge.libconcierge;

import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.text.SimpleDateFormat;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class DataExporter
{
	// Constants.
	private static final String EXPORTDIR = "xoonips_tmp";
	private static final String ZIPFILE = "XooNIpsData.zip";
	
	// Field valiables.
	private DocumentBuilder db;
	private String importdir;
	private String zipfile;
	private String exportdir;
	private String attachdir;
	private String itemtype;
	private ArrayList<LibraryData> metadata;
	private int fileid;
	private String sepa;
	private String log;

	/**
	 * The constructor.
	 */
	public DataExporter (String idir, String edir, ArrayList<LibraryData> data, String type)
	{
		// set field values.
		fileid = 1;
		metadata = data;
		itemtype = type;
		importdir = idir;
		sepa = File.separator;
		zipfile = edir + sepa + ZIPFILE;
		exportdir = edir + sepa + EXPORTDIR + sepa;
		attachdir = exportdir + "files" + sepa;
		log = "";
		
		// make target directories to export.
		File expdir = new File(exportdir);
		expdir.mkdir();
		File atcdir = new File(attachdir);
		atcdir.mkdir();
		
		// preparation for document operation.
		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		try {
			db = dbf.newDocumentBuilder();
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
			log += "Failed to creat DocumentBuilder\n";
		}
	}

	public String getLog() {
		return log;
	}
	
	/**
	 * Export metadata document
	 * @param directory Directory to export
	 * @param metadata Metadata
	 */
	public void run()
	{
		// csv to xml.
		for (int i=1; i<=metadata.size(); i++) {
			// convert.
			LibraryData ld = (LibraryData)metadata.get(i-1);
			Document doc = data2xml(i, ld);

			//save.
			try {
				TransformerFactory tff = TransformerFactory.newInstance();
				Transformer tf = tff.newTransformer();
				tf.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
				tf.transform(new DOMSource(doc), new StreamResult(exportdir+i+".xml"));
			} catch (TransformerConfigurationException e) {
				e.printStackTrace();
				log += "Failed to save the XML file of no."+Integer.toString(i)+" data";
			} catch (TransformerException e) {
				e.printStackTrace();				
				log += "Failed to save the XML file of no."+Integer.toString(i)+" data";
			}
		}
		
		// xml to zip.
		FileUtil.makeZipFile(zipfile, exportdir);
		
		// remove tmp folder.
		FileUtil.deleteAll(exportdir);
	}

	/**
	 * Convert text data to xml.
	 * @param ld
	 * @return
	 */
	private Document data2xml(int num, LibraryData ld)
	{	
		/******************* ROOT *******************/
		// root
		Document doc = db.newDocument();
		Element root = doc.createElement("item");
		root.setAttribute("version", "1.00");
		doc.appendChild(root);
		// basic root
		Element basic = doc.createElement("basic");
		basic.setAttribute("id", Integer.toString(num));
		root.appendChild(basic);
		// detail root
		Element detail = doc.createElement("detail");
		detail.setAttribute("id", Integer.toString(num));
		root.appendChild(detail);

		/******************* BASIC *******************/
		// itemtype
		Element element = doc.createElement("itemtype");
		Text text = doc.createTextNode(itemtype);
		basic.appendChild(element);
		element.appendChild(text);
		// titles
		element = doc.createElement("titles");
		basic.appendChild(element);
		//// title
		ArrayList ret = ld.getMetadata("title");
		if (ret.size() > 0) {
			Element child = doc.createElement("title");
			text = doc.createTextNode((String)ret.get(0));
			child.appendChild(text);
			element.appendChild(child);
		}
		//// title kana
		ret = ld.getMetadata("title_kana");
		if (ret.size() > 0) {
			Element child = doc.createElement("title");
			text = doc.createTextNode((String)ret.get(0));
			child.appendChild(text);
			element.appendChild(child);
		}
		//// title rome
		ret = ld.getMetadata("title_rome");
		if (ret.size() > 0) {
			Element child = doc.createElement("title");
			text = doc.createTextNode((String)ret.get(0));
			child.appendChild(text);
			element.appendChild(child);
		}
		// keywords
		element = doc.createElement("keywords");
		basic.appendChild(element);
		ret = ld.getMetadata("keyword");
		for (int i=0; i<ret.size(); i++) {
			Element child = doc.createElement("keyword");
			text = doc.createTextNode((String)ret.get(i));
			child.appendChild(text);
			element.appendChild(child);
		}
		// description
		element = doc.createElement("description");
		basic.appendChild(element);
		ret = ld.getMetadata("note");
		if (ret.size() > 0) {
			text = doc.createTextNode((String)ret.get(0));
			element.appendChild(text);
		}
		// doi
		element = doc.createElement("doi");
		basic.appendChild(element);
		ret = ld.getMetadata("sortid");
		if (ret.size() > 0) {
			text = doc.createTextNode((String)ret.get(0));
			element.appendChild(text);
		}
		// metadata below are not used
		element = doc.createElement("contributor");
		basic.appendChild(element);
		element = doc.createElement("publication_year");
		basic.appendChild(element);
		element = doc.createElement("publication_month");
		basic.appendChild(element);
		element = doc.createElement("publication_mday");
		basic.appendChild(element);
		element = doc.createElement("lang");
		basic.appendChild(element);
		element = doc.createElement("url");
		basic.appendChild(element);
		element = doc.createElement("index");
		basic.appendChild(element);

		// "last update data" and "creation data" are required 
		// from the XooNIps v32 import file.
		SimpleDateFormat formatter
	     = new SimpleDateFormat ("yyyy-MM-dd");
		Date currentTime = new Date();
		String dateString = formatter.format(currentTime);
		//
		element = doc.createElement("last_update_date");
		basic.appendChild(element);
		text = doc.createTextNode(dateString);
		element.appendChild(text);
		//
		element = doc.createElement("creation_date");
		basic.appendChild(element);
		text = doc.createTextNode(dateString);
		element.appendChild(text);

		/******************* DETAIL *******************/
		// title
		element = doc.createElement("title");
		detail.appendChild(element);
		ret = ld.getMetadata("title");
		if (ret.size() > 0) {
			text = doc.createTextNode((String)ret.get(0));
			element.appendChild(text);
		}
		// title_kana
		element = doc.createElement("title_kana");
		detail.appendChild(element);
		ret = ld.getMetadata("title_kana");
		if (ret.size() > 0) {
			text = doc.createTextNode((String)ret.get(0));
			element.appendChild(text);
		}
		// title_rome
		element = doc.createElement("title_romaji");
		detail.appendChild(element);
		ret = ld.getMetadata("title_rome");
		if (ret.size() > 0) {
			text = doc.createTextNode((String)ret.get(0));
			element.appendChild(text);
		}
		// subtitle
		ArrayList names = ld.getMetadata("atitle");
		ArrayList kanas = ld.getMetadata("atitle_kana");
		ArrayList romes = ld.getMetadata("atitle_rome");
		/// get max number
		int maxnum = names.size();
		if (kanas.size() > maxnum )	maxnum = kanas.size();
		if (romes.size() > maxnum )	maxnum = romes.size();
		for (int i=0; i<maxnum; i++) {
			// parent
			element = doc.createElement("sub_title");
			detail.appendChild(element);
			// name
			Element name = doc.createElement("sub_title_name");
			String data = "";
			if (names.size() > i)	data = (String)names.get(i);
			name.appendChild(doc.createTextNode(data));
			element.appendChild(name);
			// kana
			Element kana = doc.createElement("sub_title_kana");
			data = "";
			if (kanas.size() > i)	data = (String)kanas.get(i);
			kana.appendChild(doc.createTextNode(data));
			element.appendChild(kana);
			// rome
			Element rome = doc.createElement("sub_title_romaji");
			data = "";
			if (romes.size() > i)	data = (String)romes.get(i);
			rome.appendChild(doc.createTextNode(data));
			element.appendChild(rome);
		}
		// author
		ArrayList a_i = ld.getMetadata("author_id");
		ArrayList a_n = ld.getMetadata("author");
		ArrayList a_k = ld.getMetadata("author_kana");
		ArrayList a_r = ld.getMetadata("author_rome");
		ArrayList a_a = ld.getMetadata("author_afl");
		ArrayList a_t = ld.getMetadata("author_transafl");
		ArrayList a_o = ld.getMetadata("author_role");
		ArrayList a_l = ld.getMetadata("author_link");
		/// get max number
		maxnum = a_i.size();
		if (a_n.size() > maxnum )	maxnum = a_n.size();
		if (a_k.size() > maxnum )	maxnum = a_k.size();
		if (a_r.size() > maxnum )	maxnum = a_r.size();
		if (a_a.size() > maxnum )	maxnum = a_a.size();
		if (a_t.size() > maxnum )	maxnum = a_t.size();
		if (a_o.size() > maxnum )	maxnum = a_o.size();
		if (a_l.size() > maxnum )	maxnum = a_l.size();
		/// append
		for (int i=0; i<maxnum; i++) {
			// parent
			Element parent = doc.createElement("author");
			detail.appendChild(parent);
			// id
			Element child = doc.createElement("author_id");
			String data = "";
			if (a_i.size() > i)	data = (String)a_i.get(i);
			child.appendChild(doc.createTextNode(data));
			parent.appendChild(child);
			// name
			child = doc.createElement("author_name");
			data = "";
			if (a_n.size() > i)	data = (String)a_n.get(i);
			child.appendChild(doc.createTextNode(data));
			parent.appendChild(child);
			// kana
			child = doc.createElement("author_kana");
			data = "";
			if (a_k.size() > i)	data = (String)a_k.get(i);
			child.appendChild(doc.createTextNode(data));
			parent.appendChild(child);
			// romaji
			child = doc.createElement("author_romaji");
			data = "";
			if (a_r.size() > i)	data = (String)a_r.get(i);
			child.appendChild(doc.createTextNode(data));
			parent.appendChild(child);
			// affiliation
			child = doc.createElement("author_affiliation");
			data = "";
			if (a_a.size() > i)	data = (String)a_a.get(i);
			child.appendChild(doc.createTextNode(data));
			parent.appendChild(child);
			// translated affiliation
			child = doc.createElement("author_affiliation_translation");
			data = "";
			if (a_t.size() > i)	data = (String)a_t.get(i);
			child.appendChild(doc.createTextNode(data));
			parent.appendChild(child);
			// role
			child = doc.createElement("author_role");
			data = "";
			if (a_o.size() > i)	data = (String)a_o.get(i);
			child.appendChild(doc.createTextNode(data));
			parent.appendChild(child);
			// link
			child = doc.createElement("author_link");
			data = "";
			if (a_l.size() > i)	data = (String)a_l.get(i);
			child.appendChild(doc.createTextNode(data));
			parent.appendChild(child);
		}
		// edition
		element = doc.createElement("edition");
		detail.appendChild(element);
		ret = ld.getMetadata("edition");
		if (ret.size() > 0) {
			text = doc.createTextNode((String)ret.get(0));
			element.appendChild(text);
		}
		// publish place
		element = doc.createElement("publish_place");
		detail.appendChild(element);
		ret = ld.getMetadata("pub_place");
		if (ret.size() > 0) {
			text = doc.createTextNode((String)ret.get(0));
			element.appendChild(text);
		}
		// publisher
		element = doc.createElement("publisher");
		detail.appendChild(element);
		ret = ld.getMetadata("pub_name");
		if (ret.size() > 0) {
			text = doc.createTextNode((String)ret.get(0));
			element.appendChild(text);
		}
		// publisher kana
		element = doc.createElement("publisher_kana");
		detail.appendChild(element);
		ret = ld.getMetadata("pub_kana");
		if (ret.size() > 0) {
			text = doc.createTextNode((String)ret.get(0));
			element.appendChild(text);
		}
		// publisher romaji
		element = doc.createElement("publisher_romaji");
		detail.appendChild(element);
		ret = ld.getMetadata("pub_rome");
		if (ret.size() > 0) {
			text = doc.createTextNode((String)ret.get(0));
			element.appendChild(text);
		}
		// year f
		element = doc.createElement("year_f");
		detail.appendChild(element);
		ret = ld.getMetadata("pub_yearF");
		if (ret.size() > 0) {
			text = doc.createTextNode((String)ret.get(0));
			element.appendChild(text);
		}
		// year t
		element = doc.createElement("year_t");
		detail.appendChild(element);
		ret = ld.getMetadata("pub_yearT"); // Which is correct, e or t? 
		if (ret.size() > 0) {
			text = doc.createTextNode((String)ret.get(0));
			element.appendChild(text);
		}
		// create date
		element = doc.createElement("date_create");
		detail.appendChild(element);
		ret = ld.getMetadata("date_create");
		if (ret.size() > 0) {
			text = doc.createTextNode((String)ret.get(0));
			element.appendChild(text);
		}
		// update date
		element = doc.createElement("date_update");
		detail.appendChild(element);
		ret = ld.getMetadata("date_modify");
		if (ret.size() > 0) {
			text = doc.createTextNode((String)ret.get(0));
			element.appendChild(text);
		}
		// record date
		element = doc.createElement("date_record");
		detail.appendChild(element);
		ret = ld.getMetadata("date_record");
		if (ret.size() > 0) {
			text = doc.createTextNode((String)ret.get(0));
			element.appendChild(text);
		}
		// jtitle
		element = doc.createElement("jtitle");
		detail.appendChild(element);
		ret = ld.getMetadata("stitle");
		if (ret.size() > 0) {
			text = doc.createTextNode((String)ret.get(0));
			element.appendChild(text);
		}
		// translated jtitle
		element = doc.createElement("jtitle_translation");
		detail.appendChild(element);
		ret = ld.getMetadata("stitle_trans");
		if (ret.size() > 0) {
			text = doc.createTextNode((String)ret.get(0));
			element.appendChild(text);
		}
		// jtitle volume
		element = doc.createElement("jtitle_volume");
		detail.appendChild(element);
		ret = ld.getMetadata("stitle_vol");
		if (ret.size() > 0) {
			text = doc.createTextNode((String)ret.get(0));
			element.appendChild(text);
		}
		// jtitle issue
		element = doc.createElement("jtitle_issue");
		detail.appendChild(element);
		ret = ld.getMetadata("stitle_num");
		if (ret.size() > 0) {
			text = doc.createTextNode((String)ret.get(0));
			element.appendChild(text);
		}
		// jtitle year
		element = doc.createElement("jtitle_year");
		detail.appendChild(element);
		ret = ld.getMetadata("stitle_year");
		if (ret.size() > 0) {
			text = doc.createTextNode((String)ret.get(0));
			element.appendChild(text);
		}
		// jtitle month
		element = doc.createElement("jtitle_month");
		detail.appendChild(element);
		ret = ld.getMetadata("stitle_month");
		if (ret.size() > 0) {
			text = doc.createTextNode((String)ret.get(0));
			element.appendChild(text);
		}
		// jtitle start page
		element = doc.createElement("jtitle_spage");
		detail.appendChild(element);
		ret = ld.getMetadata("stitle_spage");
		if (ret.size() > 0) {
			text = doc.createTextNode((String)ret.get(0));
			element.appendChild(text);
		}
		// jtitle end page
		element = doc.createElement("jtitle_epage");
		detail.appendChild(element);
		ret = ld.getMetadata("stitle_epage");
		if (ret.size() > 0) {
			text = doc.createTextNode((String)ret.get(0));
			element.appendChild(text);
		}
		// keywords
		element = doc.createElement("keywords");
		detail.appendChild(element);
		ret = ld.getMetadata("keyword");
		for (int i=0; i<ret.size(); i++) {
			Element child = doc.createElement("keyword");
			text = doc.createTextNode((String)ret.get(i));
			child.appendChild(text);
			element.appendChild(child);
		}
		// classifications
		element = doc.createElement("ndc_classifications");
		detail.appendChild(element);
		ret = ld.getMetadata("category");
		for (int i=0; i<ret.size(); i++) {
			Element child = doc.createElement("ndc_classification");
			text = doc.createTextNode((String)ret.get(i));
			child.appendChild(text);
			element.appendChild(child);
		}
		// physical descriptions
		element = doc.createElement("physical_descriptions");
		detail.appendChild(element);
		ret = ld.getMetadata("format");
		for (int i=0; i<ret.size(); i++) {
			Element child = doc.createElement("physical_description");
			text = doc.createTextNode((String)ret.get(i));
			child.appendChild(text);
			element.appendChild(child);
		}
		// langs
		element = doc.createElement("langs");
		detail.appendChild(element);
		ret = ld.getMetadata("lang");
		for (int i=0; i<ret.size(); i++) {
			Element child = doc.createElement("lang");
			text = doc.createTextNode((String)ret.get(i));
			child.appendChild(text);
			element.appendChild(child);
		}
		// id issn
		element = doc.createElement("id_issns");
		detail.appendChild(element);
		ret = ld.getMetadata("id_issn");
		for (int i=0; i<ret.size(); i++) {
			Element child = doc.createElement("id_issn");
			text = doc.createTextNode((String)ret.get(i));
			child.appendChild(text);
			element.appendChild(child);
		}
		// id isbn
		element = doc.createElement("id_isbns");
		detail.appendChild(element);
		ret = ld.getMetadata("id_isbn");
		for (int i=0; i<ret.size(); i++) {
			Element child = doc.createElement("id_isbn");
			text = doc.createTextNode((String)ret.get(i));
			child.appendChild(text);
			element.appendChild(child);
		}
		// id doi
		element = doc.createElement("id_dois");
		detail.appendChild(element);
		ret = ld.getMetadata("id_doi");
		for (int i=0; i<ret.size(); i++) {
			Element child = doc.createElement("id_doi");
			text = doc.createTextNode((String)ret.get(i));
			child.appendChild(text);
			element.appendChild(child);
		}
		// id uri
		element = doc.createElement("id_uris");
		detail.appendChild(element);
		ret = ld.getMetadata("id_uri");
		for (int i=0; i<ret.size(); i++) {
			Element child = doc.createElement("id_uri");
			text = doc.createTextNode((String)ret.get(i));
			child.appendChild(text);
			element.appendChild(child);
		}
		// id local
		element = doc.createElement("id_locals");
		detail.appendChild(element);
		ret = ld.getMetadata("id_other");
		for (int i=0; i<ret.size(); i++) {
			Element child = doc.createElement("id_local");
			text = doc.createTextNode((String)ret.get(i));
			child.appendChild(text);
			element.appendChild(child);
		}
		// uri
		element = doc.createElement("uris");
		detail.appendChild(element);
		ret = ld.getMetadata("uri");
		for (int i=0; i<ret.size(); i++) {
			Element child = doc.createElement("uri");
			text = doc.createTextNode((String)ret.get(i));
			child.appendChild(text);
			element.appendChild(child);
		}
		// abstract
		element = doc.createElement("abstract");
		detail.appendChild(element);
		ret = ld.getMetadata("abst");
		if (ret.size() > 0) {
			text = doc.createTextNode((String)ret.get(0));
			element.appendChild(text);
		}
		// table of contents
		element = doc.createElement("table_of_contents");
		detail.appendChild(element);
		ret = ld.getMetadata("toc");
		if (ret.size() > 0) {
			text = doc.createTextNode((String)ret.get(0));
			element.appendChild(text);
		}
		// type of resource
		element = doc.createElement("type_of_resource");
		detail.appendChild(element);
		ret = ld.getMetadata("type");
		if (ret.size() > 0) {
			text = doc.createTextNode((String)ret.get(0));
			element.appendChild(text);
		}
		// genre
		element = doc.createElement("genre");
		detail.appendChild(element);
		ret = ld.getMetadata("genre");
		if (ret.size() > 0) {
			text = doc.createTextNode((String)ret.get(0));
			element.appendChild(text);
		}
		// access condition
		element = doc.createElement("access_condition");
		detail.appendChild(element);
		ret = ld.getMetadata("condition");
		if (ret.size() > 0) {
			text = doc.createTextNode((String)ret.get(0));
			element.appendChild(text);
		}

		/******************* FIILES *******************/
		// attachment file
		ret = ld.getMetadata("path2body");
		if (ret.size() > 0) {
			/// make a copy of a preview file.
			String path = (String)ret.get(0);
			if (!path.equals("")) {
				String src = importdir + path;
				String dst = attachdir + fileid;
				try {
					FileUtil.copy(src, dst);
				} catch (IOException e) {
					log += "Failed to make a copy of a preview file.\n";
					log += "\tsource: "+src+"\n";
					log += "\tdestination: "+dst+"\n";
				}
			
				/// get file infromation.
				String typename = "article_attachment";
				String idnumber = Integer.toString(num);
				String orgfname = FileUtil.getFilename(path);
				String cpyfname = "files/"+fileid;
				String mimetype = URLConnection.getFileNameMap().getContentTypeFor(src);
				String filesize = String.valueOf(new File(src).length());
			
				/// set metadata.
				element = doc.createElement("file");
				detail.appendChild(element);
				element.setAttribute("file_type_name", typename);
				element.setAttribute("item_id", idnumber);
				element.setAttribute("original_file_name", orgfname);
				element.setAttribute("file_name", cpyfname);
				element.setAttribute("mime_type", mimetype);
				element.setAttribute("file_size", filesize);
				fileid++;
				//// not used.
				Element child = doc.createElement("caption");
				element.appendChild(child);
			}
		}
	
		// preview files
		ret = ld.getMetadata("path2image");
		for (int i=0; i<ret.size(); i++) {
			/// make a copy of a preview file.
			String path = (String)ret.get(i);
			if (!path.equals("")) {
				String src = importdir + path;
				String dst = attachdir + fileid;
				try {
					FileUtil.copy(src, dst);
				} catch (IOException e) {
					log += "Failed to make a copy of a preview file.\n";
					log += "\tsource: "+src+"\n";
					log += "\tdestination: "+dst+"\n";
				}
			
				/// get file infromation.
				String typename = "preview";
				String idnumber = Integer.toString(num);
				String orgfname = FileUtil.getFilename(path);
				String cpyfname = "files/"+fileid;
				String mimetype = URLConnection.getFileNameMap().getContentTypeFor(src);
				String filesize = String.valueOf(new File(src).length());
			
				/// set metadata.
				element = doc.createElement("file");
				detail.appendChild(element);
				element.setAttribute("file_type_name", typename);
				element.setAttribute("item_id", idnumber);
				element.setAttribute("original_file_name", orgfname);
				element.setAttribute("file_name", cpyfname);
				element.setAttribute("mime_type", mimetype);
				element.setAttribute("file_size", filesize);
				fileid++;
				///// not used.
				Element child = doc.createElement("caption");
				element.appendChild(child);
				child = doc.createElement("thumbnail");
				element.appendChild(child);
			}
		}

		return doc;
	}
}