package jp.sourceforge.libconcierge;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;

import jp.ac.wakhok.tomoharu.csv.CSVTokenizer;

public class LibraryData {
	// Constants.
	static final private String DELIMITER = "#";
	static final public String[] KEYS = {"title", "title_kana", "title_rome", "atitle",
		"atitle_kana", "atitle_rome", "author_id", "author", "author_rome", "author_kana",
		"author_afl", "author_transafl", "author_role", "author_link", "edition",
		"pub_place", "pub_name", "pub_kana", "pub_rome", "pub_yearF", "pub_yearT",
		"date_create", "date_modify", "date_record", "format", "stitle", "stitle_trans",
		"stitle_vol", "stitle_num", "stitle_year", "stitle_month", "stitle_spage",
		"stitle_epage", "id_issn", "id_uri", "id_isbn", "id_doi", "id_other", "abst",
		"toc", "keyword", "category", "note", "lang", "type", "genre", "path2image",
		"path2body", "uri", "condition", "sortid", "aid"};
	
	// Metadata.
	private Hashtable<String, String> MetadataHash = null;

	/**
	 * The constructor.
	 * @param str
	 */
	public LibraryData() {
		MetadataHash = new Hashtable<String, String>();
	}

	/**
	 * 
	 * @param line
	 * @return
	 */
	public boolean setMetadata(String line) {
		// check number.
		boolean res = false;
		CSVTokenizer tokens	= new CSVTokenizer(line);
		if (tokens.countTokens() == KEYS.length)	res = true; 

		// analize csv data.
		for (int i=0; i<KEYS.length; i++) {
			if (tokens.hasMoreTokens()) {
				String token = tokens.nextToken();
				if (KEYS[i] == "path2body" | KEYS[i] == "path2image") {
					token = token.replace("\\", File.separator);
					token = token.replace("/", File.separator);
				}
				MetadataHash.put(KEYS[i], token);
				System.out.println(KEYS[i] +" : "+token);
			}
		}

		return res;
	}
	
	/**
	 * Extract metadata from hashtable.
	 * @param key
	 * @return
	 */
	public ArrayList getMetadata(String key) {
		ArrayList<String> ret = new ArrayList<String>();
		String data = MetadataHash.get(key);
		if (data != null) {
			String[] name = data.split(DELIMITER);
			for (int i=0; i<name.length; i++) {
				ret.add(name[i].trim());
			}
		}
		return ret;
	}
}