<?php
//  XooNIps article item type module
//  $Revision: 1.6 $
//  --------------------------------------------------------------------------
//  XooNIps Library Module Xoops modules for XooNIps Platforms
//  Copyright (C) 2006 Keio University and RIKEN, Japan. All rights reserved.
//  http://sourceforge.jp/projects/xoonips-library/
//  --------------------------------------------------------------------------
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//  --------------------------------------------------------------------------

//  XooNIps Library Article item type module

if ( ! defined( 'XOOPS_ROOT_PATH' ) ) exit();

// 1.0 -> 1.2 support XooNIps v3.24
// 1.2 -> 1.3 support XooNIps v3.3x

$modversion['name']        = _MI_XNPARTICLE_NAME;
$modversion['version']     = 1.30;
$modversion['description'] = _MI_XNPARTICLE_DESC;
$modversion['credits']     = "Keio University(http://www.lib.keio.ac.jp/) and RIKEN, Japan(http://www.riken.jp/)";
$modversion['author']      = "The XooNIps Library Module Project(http://sourceforge.jp/projects/xoonips-library/) ";
$modversion['help']        = "help.html";
$modversion['license']     = "GPL see LICENSE";
$modversion['official']    = 0;
$modversion['image']       = "images/xnparticle_slogo.png";
$modversion['dirname']     = "xnparticle";

// Sql file (must contain sql generated by phpMyAdmin or phpPgAdmin)
// All tables should not have any prefix!
$modversion['sqlfile']['mysql'] = "sql/mysql.sql";
$modversion['tables'][0] = "xnparticle_item_detail";

// Admin things
$modversion['hasAdmin'] = 1;
$modversion['adminindex'] = "admin/index.php";
$modversion['adminmenu'] = "admin/menu.php";

// Menu
$modversion['hasMain'] = 0;

// Templates
$modversion['templates'][1]['file'] = 'xnparticle_list_block.html';
$modversion['templates'][1]['description'] = 'list block';
$modversion['templates'][2]['file'] = 'xnparticle_register_block.html';
$modversion['templates'][2]['description'] = 'register block';
$modversion['templates'][3]['file'] = 'xnparticle_detail_block.html';
$modversion['templates'][3]['description'] = 'detail block';
$modversion['templates'][4]['file'] = 'xnparticle_confirm_block.html';
$modversion['templates'][4]['description'] = 'confirm block';
$modversion['templates'][5]['file'] = 'xnparticle_search_block.html';
$modversion['templates'][5]['description'] = 'search block';

// config
include_once( XOOPS_ROOT_PATH.'/modules/xoonips/condefs.php' );

$modversion['config'][1]['name'] = 'abstract_access_rights';
$modversion['config'][1]['title'] = '_MI_XNPARTICLE_CFG_SHOW_ABST';
$modversion['config'][1]['description'] = '_MI_XNPARTICLE_CFG_SHOW_ABST_DESC';
$modversion['config'][1]['formtype'] = 'select';
$modversion['config'][1]['valuetype'] = 'string';
$modversion['config'][1]['default'] = OL_PRIVATE;
$modversion['config'][1]['options'] = array('Public' => OL_PUBLIC, 'Group' => OL_GROUP_ONLY, 'Private' => OL_PRIVATE );

$modversion['config'][2]['name'] = 'pdf_access_rights';
$modversion['config'][2]['title'] = '_MI_XNPARTICLE_CFG_SHOW_PDF';
$modversion['config'][2]['description'] = '_MI_XNPARTICLE_CFG_SHOW_PDF_DESC';
$modversion['config'][2]['formtype'] = 'select';
$modversion['config'][2]['valuetype'] = 'string';
$modversion['config'][2]['default'] = OL_PRIVATE;
$modversion['config'][2]['options'] = array('Public' => OL_PUBLIC, 'Group' => OL_GROUP_ONLY, 'Private' => OL_PRIVATE );

// Blocks

//Install script
$modversion['onInstall']   = 'include/oninstall.inc.php'; 
$modversion['onUpdate']    = 'include/onupdate.inc.php';
$modversion['onUninstall'] = 'include/onuninstall.inc.php';
?>

