<?php
// $Id: postgresqldatabase.php,v 0.1 2008/04/05 02:37:24 megalabo Exp $
//  ------------------------------------------------------------------------ //
//              XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
// Author: Kazumi Ono (AKA onokazu)                                          //
// URL: http://www.myweb.ne.jp/, http://www.xoops.org/, http://jp.xoops.org/ //
// Project: The XOOPS Project                                                //
// ------------------------------------------------------------------------- //
/**
 * @package     kernel
 * @subpackage  database
 * 
 * @author      Kazumi Ono  <onokazu@xoops.org>
 * @copyright   copyright (c) 2000-2003 XOOPS.org
 */

/**
 * base class
 */
include_once XOOPS_ROOT_PATH."/class/database/database.php";

/**
 * connection to a mysql database
 * 
 * @abstract
 * 
 * @author      Kazumi Ono  <onokazu@xoops.org>
 * @copyright   copyright (c) 2000-2003 XOOPS.org
 * 
 * @package     kernel
 * @subpackage  database
 */
class XoopsPostgresqlDatabase extends XoopsDatabase
{
    /**
     * Database connection
     * @var resource
     */
    var $conn;

    /**
     * connect to the database
     * 
     * @param bool $selectdb select the database now?
     * @return bool successful?
     */
  function connect($selectdb = true)
  {
    $selectConn_string = "host=".XOOPS_DB_HOST." port=5432 dbname=".XOOPS_DB_NAME." user=".XOOPS_DB_USER." password=".XOOPS_DB_PASS;
    if (XOOPS_DB_PCONNECT == 1) {
        $this->conn = @pg_pconnect($selectConn_string);
    } else {
        $this->conn = @pg_pconnect($selectConn_string);
    }
    if (!$this->conn) {
      $this->logger->addQuery('', $this->error($this->conn), $this->errno($this->conn));
      return false;
    }
    //$this->query("SET NAMES 'EUC_JP'");
    return true;
  }

    /**
     * generate an ID for a new row
     * 
     * This is for compatibility only. Will always return 0, because MySQL supports
     * autoincrement for primary keys.
     * 
     * @param string $sequence name of the sequence from which to get the next ID
     * @return int always 0, because mysql has support for autoincrement
     */
  function genId($table)
  {
    $sql = "SELECT * FROM ".$table;
    $result = $this->queryF($sql, 1);
    if (!$result){
      return false;
    }
    if (pg_num_rows($result) == 0){
      return 1;
    }
    $field_name = pg_field_name($result, 0);
    $sql = "SELECT ".$field_name." 
            FROM ".$table." 
            ORDER BY ".$field_name." DESC";
    $result = $this->queryF($sql, 1);
    if (!$result){
      return false;
    }
    //return $result;
    return @pg_fetch_result($result, 0, $field_name)+1;
  }

    /**
     * Get a result row as an enumerated array
     * 
     * @param resource $result
     * @return array
     */
    function fetchRow($result)
    {
        //return @mysql_fetch_row($result);
        return @pg_fetch_row($result) ;
    }

    /**
     * Fetch a result row as an associative array
     *
     * @return array
     */
    function fetchArray($result)
    {
        //return @mysql_fetch_assoc( $result );
        return @pg_fetch_assoc($result);
    }

    /**
     * Fetch a result row as an associative array
     *
     * @return array
     */
    function fetchBoth($result)
    {
        //return @mysql_fetch_array( $result, MYSQL_BOTH );
        return @pg_fetch_array( $result);
    }

    /**
     * Get the ID generated from the previous INSERT operation
     * 
     * @return int
     */
/*
    function getInsertId($result)
    {
        //return mysql_insert_id($this->conn);
        return pg_last_oid($result);
    }
*/
/*
  function getInsertId($table)
  {
    $sql = "SELECT * FROM ".$table;
    $result = $this->query($sql);
    $rowNum = pg_num_rows($result) - 1;
    $fieldName = pg_field_name($result, 0);
    $newId = pg_fetch_result($result, $rowNum, $fieldName) ;
    return $newId ;
  }
*/

  function getInsertId($table)
  {
    $sql = "SELECT * FROM ".$table;
    $result = $this->queryF($sql, 1);
    if (!$result) {
      return false;
    }
    $field_name = pg_field_name($result, 0);
    $sql = "SELECT ".$field_name." 
            FROM ".$table." 
            ORDER BY ".$field_name." DESC";
    $result = $this->queryF($sql, 1);
    if (!$result){
      return false;
    }
    return @pg_fetch_result($result, 0, $field_name);
  }

    /**
     * Get number of rows in result
     * 
     * @param resource query result
     * @return int
     */
    function getRowsNum($result)
    {
        //return @mysql_num_rows($result);
        return @pg_num_rows($result);

    }

    /**
     * Get number of affected rows
     *
     * @return int
     */
    function getAffectedRows($result)
    {
        //return mysql_affected_rows($this->conn);
        return pg_affected_rows($result);
    }

    /**
     * Close MySQL connection
     * 
     */
    function close()
    {
        //mysql_close($this->conn);
        pg_close($this->conn);
    }

    /**
     * will free all memory associated with the result identifier result.
     * 
     * @param resource query result
     * @return bool TRUE on success or FALSE on failure. 
     */
    function freeRecordSet($result)
    {
        //return mysql_free_result($result);
        return pg_free_result($result);
    }

    /**
     * Returns the text of the error message from previous MySQL operation
     * 
     * @return bool Returns the error text from the last MySQL function, or '' (the empty string) if no error occurred. 
     */
    function error($result)
    {
        //return @mysql_error();
        return @pg_result_error($result);
    }

    /**
     * Returns the numerical value of the error message from previous MySQL operation 
     * 
     * @return int Returns the error number from the last MySQL function, or 0 (zero) if no error occurred. 
     */
    function errno()
    {
        //return @mysql_errno();
      return @pg_result_status($result);
    }

    /**
     * Returns escaped string text with single quotes around it to be safely stored in database
     * 
     * @param string $str unescaped string text
     * @return string escaped string text with single quotes around
     */
    function quoteString($str)
    {
         $str = "'".str_replace('\\"', '"', addslashes($str))."'";
         return $str;
    }

  /**
  * perform a query on the database
  * 
  * @param string $sql a valid MySQL query
  * @param $limit number of records to return
  * @param $start offset of first record to return
  * @return resource query result or FALSE if successful
  * or TRUE if successful and no result
  */
  function &queryF($sql, $limit=0, $start=0)
  {
    //posrgresqlmysqlƂłlimitstartقȂA', 'OFFSETƂ//-->
    if (!empty($limit) or ($limit > 0)) {
      if (empty($start) or ($start == 0)){
        $start = 0;
      }
      $sql = $sql. " LIMIT ".$limit." OFFSET ".$start."";
    }
    $result = @pg_query($this->conn, $sql) ;
    if ( $result ) {
      $this->logger->addQuery($sql);
      return $result;
    } else {
      $this->logger->addQuery($sql, $this->error($result), $this->errno($result));
      return  false;
    }
  }

    /**
     * perform a query
     * 
     * This method is empty and does nothing! It should therefore only be
     * used if nothing is exactly what you want done! ;-)
     * 
     * @param string $sql a valid MySQL query
     * @param int $limit number of records to return
     * @param int $start offset of first record to return
     * 
     * @abstract
     */
    function &query($sql, $limit=0, $start=0)
    {

    }

    /**
     * perform queries from SQL dump file in a batch
     * 
     * @param string $file file path to an SQL dump file
     * 
     * @return bool FALSE if failed reading SQL file or TRUE if the file has been read and queries executed
     */
    function queryFromFile($file){
        if (false !== ($fp = fopen($file, 'r'))) {
            include_once XOOPS_ROOT_PATH.'/class/database/sqlutility.php';
            $sql_queries = trim(fread($fp, filesize($file)));
            SqlUtility::splitMySqlFile($pieces, $sql_queries);
            foreach ($pieces as $query) {
                // [0] contains the prefixed query
                // [4] contains unprefixed table name
                $prefixed_query = SqlUtility::prefixQuery(trim($query), $this->prefix());
                if ($prefixed_query != false) {
                    $this->query($prefixed_query[0]);
                }
            }
            return true;
        }
        return false;
    }
    
    /**
     * Get field name
     *
     * @param resource $result query result
     * @param int numerical field index
     * @return string
     */
    function getFieldName($result, $offset)
    {
        return mysql_field_name($result, $offset);
    }

    /**
     * Get field type
     *
     * @param resource $result query result
     * @param int $offset numerical field index
     * @return string
     */
    function getFieldType($result, $offset)
    {
        return mysql_field_type($result, $offset);
    }

    /**
     * Get number of fields in result
     *
     * @param resource $result query result
     * @return int
     */
    function getFieldsNum($result)
    {
        return mysql_num_fields($result);
    }
}

/**
 * Safe Connection to a Postgresql database.
 * 
 * 
 * @author Kazumi Ono <onokazu@xoops.org>
 * @copyright copyright (c) 2000-2003 XOOPS.org
 * 
 * @package kernel
 * @subpackage database
 */
class XoopsPostgresqlDatabaseSafe extends XoopsPostgresqlDatabase
{

    /**
     * perform a query on the database
     * 
     * @param string $sql a valid MySQL query
     * @param int $limit number of records to return
     * @param int $start offset of first record to return
     * @return resource query result or FALSE if successful
     * or TRUE if successful and no result
     */
    function &query($sql, $limit=0, $start=0)
    {
        $ret =& $this->queryF($sql, $limit, $start);
        return $ret;
    }
}

/**
 * Read-Only connection to a MySQL database.
 * 
 * This class allows only SELECT queries to be performed through its 
 * {@link query()} method for security reasons.
 * 
 * 
 * @author Kazumi Ono <onokazu@xoops.org>
 * @copyright copyright (c) 2000-2003 XOOPS.org
 * 
 * @package kernel
 * @subpackage database
 */
class XoopsPostgresqlDatabaseProxy extends XoopsPostgresqlDatabase
{

    /**
     * perform a query on the database
     * 
     * this method allows only SELECT queries for safety.
     * 
     * @param string $sql a valid MySQL query
     * @param int $limit number of records to return
     * @param int $start offset of first record to return
     * @return resource query result or FALSE if unsuccessful
     */
    function &query($sql, $limit=0, $start=0)
    {
        $ret = false;
        $sql = ltrim($sql);
        if (strtolower(substr($sql, 0, 6)) == 'select') {
        //if (preg_match("/^SELECT.*/i", $sql)) {
            $ret =& $this->queryF($sql, $limit, $start);
        } else {
            $this->logger->addQuery($sql, 'Database update not allowed during processing of a GET request', 0);
        }
        return $ret;
    }
}
?>