--
-- Table structure for table `bb_categories`
--
CREATE TABLE bb_categories (
  cat_id        serial          NOT NULL,
  cat_title     varchar(100)    NOT NULL default '',
  cat_order     varchar(10)     default NULL,
  PRIMARY KEY (cat_id)
);
-- --------------------------------------------------------

--
-- Table structure for table `bb_forum_access`
--
CREATE TABLE bb_forum_access (
  forum_id      integer     NOT NULL default '0',
  user_id       integer     NOT NULL default '0',
  can_post      smallint    NOT NULL default '0',
  PRIMARY KEY (forum_id, user_id)
);

-- --------------------------------------------------------

--
-- Table structure for table `bb_forum_mods`
--
CREATE TABLE bb_forum_mods (
  forum_id      integer     NOT NULL default '0',
  user_id       integer     NOT NULL default '0'
);

-- --------------------------------------------------------

--
-- Table structure for table `bb_forums`
--
CREATE TABLE bb_forums (
  forum_id              serial          NOT NULL,
  forum_name            varchar(150)    NOT NULL default '',
  forum_desc            text,
  forum_access          smallint        NOT NULL default '1',
  forum_moderator       integer         default NULL,
  forum_topics          integer         NOT NULL default '0',
  forum_posts           integer         NOT NULL default '0',
  forum_last_post_id    integer         NOT NULL default '0',
  cat_id                integer         NOT NULL default '0',
  forum_type            integer         default '0',
  allow_html            smallint        NOT NULL DEFAULT '0',
  allow_sig             smallint        NOT NULL DEFAULT '0',
  posts_per_page        smallint        NOT NULL DEFAULT '20',
  hot_threshold         smallint        NOT NULL DEFAULT '10',
  topics_per_page       smallint        NOT NULL DEFAULT '20',
  PRIMARY KEY (forum_id)
);

-- --------------------------------------------------------

--
-- Table structure for table `bb_posts`
--
CREATE TABLE bb_posts (
  post_id       serial          NOT NULL,
  pid           integer         NOT NULL default '0',
  topic_id      integer         NOT NULL default '0',
  forum_id      integer         NOT NULL default '0',
  post_time     integer         NOT NULL default '0',
  uid           integer         NOT NULL default '0',
  poster_ip     varchar(15)     NOT NULL default '',
  subject       varchar(255)    NOT NULL default '',
  nohtml        smallint        NOT NULL default '0',
  nosmiley      smallint        NOT NULL default '0',
  icon          varchar(25)     NOT NULL default '',
  attachsig     smallint        NOT NULL default '0',
  PRIMARY KEY (post_id)
);

-- --------------------------------------------------------

--
-- Table structure for table `bb_posts_text`
--
CREATE TABLE bb_posts_text (
  post_id       serial      NOT NULL,
  post_text     text,
  PRIMARY KEY (post_id)
);

-- --------------------------------------------------------

--
-- Table structure for table `bb_topics`
--
CREATE TABLE bb_topics (
  topic_id              serial          NOT NULL,
  topic_title           varchar(255)    default NULL,
  topic_poster          integer         NOT NULL default '0',
  topic_time            integer         NOT NULL default '0',
  topic_views           integer         NOT NULL default '0',
  topic_replies         integer         NOT NULL default '0',
  topic_last_post_id    integer         NOT NULL default '0',
  forum_id              integer         NOT NULL default '0',
  topic_status          smallint        NOT NULL default '0',
  topic_sticky          smallint        NOT NULL default '0',
  PRIMARY KEY (topic_id)
);

