<?php
/*
 * $Id: weblog_recent.php,v 1.5 2003/11/08 08:11:16 wellwine Exp $
 * Copyright (c) 2003 by Jeremy N. Cowgar <jc@cowgar.com>
 * Copyright (c) 2003 by wellwine <http://wellwine.zive.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * You may not change or alter any portion of this comment or credits
 * of supporting developers from this source code or any supporting
 * source code which is considered copyrighted (c) material of the
 * original comment or credit authors.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

define('_WEBLOG_DIRNAME', 'weblog');
/*
 * $options[0] = max results
 * $options[1] = use avatars
 * $options[2] = link to entry list
 */
function b_weblog_top_weblogs_show($options) {
    global $xoopsDB, $xoopsUser;

    $max_results = $options[0];
    $use_avatars = $options[1];
    $link_entries = $options[2];
    
    $currentuid = !empty($xoopsUser) ? $xoopsUser->getVar('uid','E') : 0;

    $block = array();
    $rank = 0;

    $sql = sprintf('SELECT b.user_id, b.created, u.uname, u.user_avatar, count(b.blog_id) as count FROM %s as b, %s as u',
                   $xoopsDB->prefix('weblog'), $xoopsDB->prefix('users'));
    $sql = sprintf('%s WHERE (b.private = \'N\' OR b.user_id=\'%d\')  AND b.user_id=u.uid GROUP BY b.user_id ORDER BY count DESC, b.created DESC',
                   $sql, $currentuid);
    $result = $xoopsDB->query($sql, $max_results, 0);

    while ($myrow = $xoopsDB->fetchArray($result)) {
        $rank++;

        // Get the user, and retrieve his avatar
        $entry = array();
        $entry['rank'] = $rank;

        // Retrieve his/her avatar
        $entry['use_avatar'] = 0;
        $entry['avatar_img'] = '';
        if ($use_avatars==1) {
            $avatar = $myrow['user_avatar'];
            if (!empty($avatar) && $avatar != 'blank.gif') {
                $entry['use_avatar'] = 1;
                $entry['avatar_img'] = sprintf('%s/uploads/%s', XOOPS_URL, $avatar);
            }
        }
        if ($link_entries==1) {
            $entry['profile_uri'] = sprintf('%s/modules/%s/index.php?user_id=%d',
                                            XOOPS_URL, _WEBLOG_DIRNAME, $myrow['user_id']);
        } else {
            $entry['profile_uri'] = sprintf('%s/userinfo.php?uid=%d', XOOPS_URL, $myrow['user_id']);
        }
        $entry['uname'] = $myrow['uname'];
        $entry['count'] = $myrow['count'];
        $block['entries'][] = $entry;
    }
    return $block;
}

/*
 * $options[0] = max results
 * $options[1] = use avatars
 * $options[2] = link to entry list
 */
function b_weblog_top_weblogs_edit($options) {
    $form  = '<table>';
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%d" /></td></tr>',
                     _MB_WEBLOG_EDIT_NUMBER_OF_ENTRIES, intval($options[0]));
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%d" /></td></tr>',
                     _MB_WEBLOG_EDIT_USE_AVATARS, intval($options[1]));
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%d" /></td></tr>',
                     _MB_WEBLOG_EDIT_LINK_TO_LIST, intval($options[2]));
    $form .= '</table>';
    return $form;
}

/*
 * $options[0] = number of entries to show
 * $options[1] = max size of the title
 * $options[2] = date format
 * $options[3] = use avatars (only in large mode)
 * $options[4] = size (1=small, 2=midium, 3=large)
 * $options[5] = link to entry list (only when author names shown)
 */
function b_weblog_recent_show($options) {
    global $xoopsDB, $xoopsUser, $xoopsConfig;

    $max_entries = $options[0];
    $max_size = $options[1];
    $date_format = $options[2];
    $use_avatars = $options[3];
    $block_size = $options[4];
    $link_entries = $options[5];

    $currentuid = !empty($xoopsUser) ? $xoopsUser->getVar('uid','E') : 0;
  
    $myts =& MyTextSanitizer::getInstance();
    $block = array();
    $sql = sprintf('SELECT b.blog_id, b.created, b.user_id, b.title, b.comments, b.reads, u.uname, u.user_avatar FROM %s as b, %s as u',
                   $xoopsDB->prefix('weblog'), $xoopsDB->prefix('users'));
    $sql = sprintf('%s WHERE (b.private = \'N\' OR b.user_id=\'%d\') AND b.user_id=u.uid ORDER BY b.created DESC',
                   $sql, $currentuid);

    // Need to figure out how to access the module config while in a block
    //$result = $xoopsDB->query($sql, $xoopsModuleConfig['numinrecentblock'], 0);
    $result = $xoopsDB->query($sql, $max_entries, 0);
    while ($myrow=$xoopsDB->fetchArray($result)) {
        $entry = array();
        $title = $myts->makeTboxData4Show($myrow['title']);
        if ( !XOOPS_USE_MULTIBYTES && $block_size != 3) {
            if (strlen($title) >= $max_size) {
                $title = substr($title, 0, ($max_size -1))."...";
            }
        }

        // Retrieve his/her avatar
        $entry['use_avatar'] = 0;
        $entry['avatar_img'] = '';
        if ($use_avatars==1) {
            $avatar = $myrow['user_avatar'];
            if (!empty($avatar) && $avatar != 'blank.gif') {
                $entry['use_avatar'] = 1;
                $entry['avatar_img'] = sprintf('%s/uploads/%s', XOOPS_URL, $avatar);
            }
        }

        $entry['uname'] = $myts->makeTboxData4Show($myrow['uname']);
        if ($link_entries==1) {
            $entry['profile_uri'] = sprintf('%s/modules/%s/index.php?user_id=%d',
                                            XOOPS_URL, _WEBLOG_DIRNAME, $myrow['user_id']);
        } else {
            $entry['profile_uri'] = sprintf('%s/userinfo.php?uid=%d', XOOPS_URL, $myrow['user_id']);
        }
        $entry['title'] = $title;
        $entry['entry_url'] = sprintf('%s/modules/%s/details.php?blog_id=%d',
                                      XOOPS_URL, _WEBLOG_DIRNAME, $myrow['blog_id']);
        $entry['date'] = formatTimestamp($myrow['created'], $date_format, $xoopsConfig['default_TZ']);
        $entry['comments'] = $myrow['comments'];;
        $entry['reads'] = $myrow['reads'];
        $block['entries'][] = $entry;
    }

    $block['type'] = $block_size;
    $block['lang_title'] = _MB_WEBLOG_LANG_TITLE;
    $block['lang_author'] = _MB_WEBLOG_LANG_AUTHOR;
    $block['lang_comments'] = _MB_WEBLOG_LANG_COMMENTS;
    $block['lang_posted'] = _MB_WEBLOG_LANG_POSTED;
    $block['lang_reads'] = _MB_WEBLOG_LANG_READS;
    $block['weblogs_url'] = sprintf('%s/modules/%s/index.php', XOOPS_URL, _WEBLOG_DIRNAME);
    $block['lang_moreweblogs'] = _MB_WEBLOG_LANG_MOREWEBLOGS;

    return $block;
}

function b_weblog_recent_edit($options) {
    $form  = '<table>';
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%d" /></td></tr>',
                     _MB_WEBLOG_EDIT_NUMBER_OF_ENTRIES, intval($options[0]));
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%d" /></td></tr>',
                     _MB_WEBLOG_EDIT_MAX_TITLE_LENGTH, intval($options[1]));
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%s" /></td></tr>',
                     _MB_WEBLOG_EDIT_DATE_FORMAT, $options[2]);
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%s" /></td></tr>',
                     _MB_WEBLOG_EDIT_USE_AVATARS, $options[3]);
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%s" /></td></tr>',
                     _MB_WEBLOG_EDIT_TYPE, $options[4]);
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%d" /></td></tr>',
                     _MB_WEBLOG_EDIT_LINK_TO_LIST, intval($options[5]));
    $form .= '</table>';
    return $form;
}
?>
