<?php
/*
 * $Id: category.php,v 1.2 2003/10/26 08:28:42 wellwine Exp $
 * Copyright (c) 2003 by Hiro SAKAI (http://wellwine.zive.net/)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * You may not change or alter any portion of this comment or credits
 * of supporting developers from this source code or any supporting
 * source code which is considered copyrighted (c) material of the
 * original comment or credit authors.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */

include_once(sprintf('%s/class/xoopsobject.php', XOOPS_ROOT_PATH));
include_once(sprintf('%s/class/xoopstree.php', XOOPS_ROOT_PATH));

class WeblogCategory extends XoopsObject {
    /**
     * Constructs an instance of this class
     */
    function WeblogCategory() {
        $this->XoopsObject();

        $this->initVar("cat_id", XOBJ_DTYPE_INT, 0, false);
        $this->initVar("cat_pid", XOBJ_DTYPE_INT, 0, true);
        $this->initVar("cat_created", XOBJ_DTYPE_INT, 0, true);
        $this->initVar("cat_title", XOBJ_DTYPE_TXTBOX, null, true, 50, true);
        $this->initVar("cat_description", XOBJ_DTYPE_TXTBOX, null, false, null, true);
        $this->initVar("cat_imgurl", XOBJ_DTYPE_URL, null, false, 150, true);
    }
}

class WeblogCategoryHandler extends XoopsObjectHandler {

    var $mytree;

    function &create() {
        return new WeblogCategory();
    }

    function &get($cat_id) {
        $cat_id = intval($cat_id);
        if ($cat_id > 0 ) {
            $sql = sprintf('SELECT cat_id, cat_pid, cat_title, cat_created, cat_description, cat_imgurl FROM %s WHERE cat_id=%d',
                           $this->db->prefix(WEBLOG_DB_PREFIX_CAT), $cat_id);
            if ($result = $this->db->query($sql)) {
                if ($this->db->getRowsNum($result)==1) {
                    $cat = $this->create();
                    $cat->assignVars($this->db->fetchArray($result));
                    return $cat;
                }
            }
        }
        return false;
    }

    function insert(&$category) {
        if (get_class($category) != 'weblogcategory') {  // must be lowercase only
            return false;
        }
        if (!$category->isDirty()) {
            return true;
        }
        if (!$category->cleanVars()) {
            return false;
        }

        foreach ($category->cleanVars as $k => $v) {
            ${$k} = $v;
        }

        $count = $this->getCount(new Criteria('cat_id', $cat_id));
        if ($cat_id > 0 && $count > 0) {
            $sql = sprintf('UPDATE %s SET cat_pid=%d, cat_created=%d, cat_title=%s, cat_description=%s, cat_imgurl=%s WHERE cat_id=%d',
                           $this->db->prefix(WEBLOG_DB_PREFIX_CAT),
                           $cat_pid, $cat_created,
                           $this->db->quoteString($cat_title),
                           $this->db->quoteString($cat_description),
                           $this->db->quoteString($cat_imgurl),
                           $cat_id);
        } else {
            $sql = sprintf('INSERT INTO %s (cat_pid, cat_created, cat_title, cat_description, cat_imgurl) VALUES (%d, %d, %s, %s, %s)',
                           $this->db->prefix(WEBLOG_DB_PREFIX_CAT),
                           $cat_pid, $cat_created,
                           $this->db->quoteString($cat_title),
                           $this->db->quoteString($cat_description),
                           $this->db->quoteString($cat_imgurl));
        }
        if (!$result = $this->db->queryF($sql)) {  // must be queryF()
            return false;
        }

        if (empty($cat_id)) {
            $category->setVar('cat_id', $this->db->getInsertId());
        }

        return true;
    }

    function delete(&$category) {
        if (get_class($category) != 'weblogcategory') {
            return false;
        }

        $sql = sprintf('DELETE FROM %s WHERE cat_id=%d LIMIT 1',
                       $this->db->prefix(WEBLOG_DB_PREFIX_CAT), $category->getVar('cat_id'));
        if (!$result = $this->db->queryF($sql)) {  // must be queryF()
            return false;
        }
        return true;
    }

    function getCount($criteria=null) {
        $sql = sprintf('SELECT count(*) as count FROM %s', $this->db->prefix(WEBLOG_DB_PREFIX_CAT));
        if (isset($criteria) && is_subclass_of($criteria, 'criteriaelement')) {
            $sql .= sprintf(' %s', $criteria->renderWhere());
        }
        if (!$result = $this->db->query($sql)) {
            return 0;
        }
        $count = $this->db->fetchArray($result);
        return $count['count'];
    }

    function &getObjects($criteria=null, $id_as_key=false) {
        $ret = array();
        $limit = $start = 0;

        $sql = sprintf('SELECT * FROM %s',
                       $this->db->prefix(WEBLOG_DB_PREFIX_CAT));
        if (isset($criteria) && is_subclass_of($criteria, 'criteriaelement')) {
            $sql .= sprintf(' %s', $criteria->renderWhere());
            //$groupby = trim(str_replace('GROUP BY', "", $criteria->getGroupby()));
            //$sql .= ($groupby=='')?'':sprintf(' %s', $criteria->getGroupby());
            $sort = ($criteria->getSort()!='') ? $criteria->getSort() : 'cat_id';
            $sql .= sprintf(' ORDER BY %s %s', $sort, $criteria->getOrder());
            $limit = $criteria->getLimit();
            $start = $criteria->getStart();
        }
        if (!$result = $this->db->query($sql, $limit, $start)) {
            return $ret;
        }
        while ($myrow = $this->db->fetchArray($result)) {
            $category = $this->create();
            $category->assignVars($myrow);
            if ($id_as_key) {
                $ret[$myrow['cat_id']] =& $category;
            } else {
                $ret[] =& $category;
            }
            unset($category);
        }
        return $ret;
    }

    function getAllChildrenIds($cat_id) {
        $mytree =& $this->getTreeInstance();//new XoopsTree($this->db->prefix(WEBLOG_DB_PREFIX_CAT), 'cat_id', 'cat_pid');
        return $mytree->getAllChildId($cat_id);
    }

    function getFirstChildren($cat_id) {
        $mytree =& $this->getTreeInstance();//new XoopsTree($this->db->prefix(WEBLOG_DB_PREFIX_CAT), 'cat_id', 'cat_pid');
        $subarr = $mytree->getFirstChildId($cat_id, 'cat_id');
        $criteria = new criteriaCompo(new criteria('cat_id', -1));
        foreach ($subarr as $sub) {
            $criteria->add(new criteria('cat_id', $sub), 'OR');
        }
        $subcat =& $this->getObjects($criteria);
        return $subcat;
    }

    function getParents($cat_id) {
        $mytree =& $this->getTreeInstance();//new XoopsTree($this->db->prefix(WEBLOG_DB_PREFIX_CAT), 'cat_id', 'cat_pid');
        $arr = $mytree->getAllParentId($cat_id);
        $parents = array();
        foreach($arr as $p) {
            $parents[] = $this->get($p);
        }
        return $parents;
    }

    function getNicePathFromId($cat_id, $url) {
        $mytree =& $this->getTreeInstance();//new XoopsTree($this->db->prefix(WEBLOG_DB_PREFIX_CAT), 'cat_id', 'cat_pid');
        return $mytree->getNicePathFromId($cat_id, 'cat_title', $url);
    }

    function getMySelectBox($cat_id=0) {
        $mytree =& $this->getTreeInstance();
        ob_start();
        $mytree->makeMySelBox('cat_title', 'cat_title', $cat_id);
        $selbox = ob_get_contents();
        ob_end_clean();
        return $selbox;
    }

    /**
     * @access private
     */
    function &getTreeInstance() {
        static $instance;
        if (!isset($instance)) {
            $instance =& new XoopsTree($this->db->prefix(WEBLOG_DB_PREFIX_CAT), 'cat_id', 'cat_pid');
        }
        return $instance;
    }
}
?>