<?php
/*
 * $Id: weblog_recent.php,v 1.15 2005/05/14 03:11:14 tohokuaiki Exp $
 * Copyright (c) 2003 by Jeremy N. Cowgar <jc@cowgar.com>
 * Copyright (c) 2003 by wellwine <http://wellwine.zive.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * You may not change or alter any portion of this comment or credits
 * of supporting developers from this source code or any supporting
 * source code which is considered copyrighted (c) material of the
 * original comment or credit authors.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

if( ! defined( 'WEBLOG_BLOCK_TBCENTER_INCLUDED' ) ) {
define( 'WEBLOG_BLOCK_TBCENTER_INCLUDED' , 1 ) ;


// $options[0] is always weblog dirname.
/*
 * $options[1] = max results
 * $options[2] = use avatars
 * $options[3] = link to entry list
 */
function b_weblog_tbcenter_show($options) {
    global $xoopsDB, $xoopsUser ;

	$mydirname = empty( $options[0] ) ? basename( dirname( dirname( __FILE__ ) ) ) : $options[0] ;
    include_once(sprintf('%s/modules/%s/config.php', XOOPS_ROOT_PATH, $mydirname ));

	$mydirname = empty( $options[0] ) ? basename( dirname( dirname( __FILE__ ) ) ) : $options[0] ;
    $max_show = $options[1];
    $max_size_contents = $options[2] ;
    $tbcenter_category = $options[3] ;
    $currentuid = !empty($xoopsUser) ? $xoopsUser->getVar('uid','E') : 0;

    $myts =& MyTextSanitizer::getInstance();

    $block = array();
    $rank = 0;

    $sql = sprintf('SELECT b.blog_id, b.title, b.contents FROM %s as b, %s as c',
                   $xoopsDB->prefix($mydirname), $xoopsDB->prefix($mydirname.'_category'));
    $sql = sprintf('%s WHERE (b.private = \'N\' OR b.user_id=\'%d\') AND c.cat_id=b.cat_id AND c.cat_title=\'%s\' ORDER BY b.created DESC',
                   $sql, $currentuid, $tbcenter_category ) ;
    $result = $xoopsDB->query($sql, $max_show, 0);
	
    while ($myrow = $xoopsDB->fetchArray($result)) {
        $rank++;
        // Get the user, and retrieve his avatar
        $entry = array();
        if( $max_size_contents ){
            $contents = parse_viewmode( strip_tags($myts->displayTarea($myrow['contents'])) , $myrow['blog_id'] ,"index" ) ;
            $contents = xoops_substr( $contents , 0 , $max_size_contents ) ;
        }else{
			$contents = "" ;
		}
		$entry['entry_url'] = sprintf( '%s/modules/%s/details.php?blog_id=%d' , XOOPS_URL , $mydirname , $myrow['blog_id'] ) ;
		$entry['tb_url'] = sprintf( '%s/modules/%s/tb.php/%d' , XOOPS_URL , $mydirname , $myrow['blog_id'] ) ;
		$entry['title'] = $myts->makeTboxData4Show($myrow['title']);
        $entry['contents'] = $contents ;
        $block['entries'][] = $entry;
    }
    return $block;
}

/*
 * $options[1] = max show
 * $options[2] = contents length
 */
function b_weblog_tbcenter_edit($options) {
	$mydirname = empty( $options[0] ) ? basename( dirname( dirname( __FILE__ ) ) ) : $options[0] ;
    $form  = '<table>';
    $form .= "<input type='hidden' name='options[]' value='$mydirname' />\n" ;
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%d" /></td></tr>',
                     '_MB_WEBLOG_EDIT_TBCENTER_ENTRIES', intval($options[1]));
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%d" /></td></tr>',
                     '_MB_WEBLOG_EDIT_TBCENTER_CONTENTS_NUM', intval($options[2]));
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%d" /></td></tr>',
                     '_MB_WEBLOG_EDIT_TBCENTER_CATEGORY', strval($options[3]));
    $form .= '</table>';
    return $form;
}

}
?>