<?php
/**
 * $Id: print.php,v 1.1 2003/08/29 13:43:58 wellwine Exp $
 * Copyright (c) 2003 by Hiro SAKAI (http://wellwine.zive.net/)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * You may not change or alter any portion of this comment or credits
 * of supporting developers from this source code or any supporting
 * source code which is considered copyrighted (c) material of the
 * original comment or credit authors.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
require('../../mainfile.php');
require_once(XOOPS_ROOT_PATH.'/class/template.php');

$blog_id = isset($HTTP_GET_VARS['blog_id']) ? intval($HTTP_GET_VARS['blog_id']) : 0;
if ( empty($blog_id) ) {
	redirect_header("index.php");
}

// Include our module's language file
if ( file_exists(XOOPS_ROOT_PATH.'/modules/'.$xoopsModule->dirname().'/language/'.$xoopsConfig['language'].'/main.php') ) {
  require_once(XOOPS_ROOT_PATH.'/modules/'.$xoopsModule->dirname().'/language/'.$xoopsConfig['language'].'/main.php');
  require_once(XOOPS_ROOT_PATH.'/modules/'.$xoopsModule->dirname().'/language/'.$xoopsConfig['language'].'/modinfo.php');
} else {
  require_once(XOOPS_ROOT_PATH.'/modules/'.$xoopsModule->dirname().'/language/english/main.php');
  require_once(XOOPS_ROOT_PATH.'/modules/'.$xoopsModule->dirname().'/language/english/modinfo.php');
}

$myts =& MyTextSanitizer::getInstance();

$currentuid = !empty($xoopsUser) ? $xoopsUser->getVar('uid','E') : 0;
$isAdmin = !empty($xoopsUser) && $xoopsUser->isAdmin($xoopsModule->mid());

header ('Content-Type:text/html; charset='._CHARSET);
$tpl = new XoopsTpl();
$tpl->xoops_setTemplateDir(XOOPS_ROOT_PATH.'/themes');
$tpl->xoops_setCaching(2);
$tpl->xoops_setCacheTime(10);

$sql = 'SELECT bl.blog_id,bl.created, bl.user_id, u.uname, bl.title, bl.contents, bl.private,bl.reads '.
  'FROM '.$xoopsDB->prefix('weblog').' as bl, '.$xoopsDB->prefix('users').' as u '.
  "WHERE (bl.private = 'N' OR bl.user_id='$currentuid') AND bl.user_id=u.uid AND bl.blog_id='$blog_id'";
$results=$xoopsDB->query($sql);
$blog=$xoopsDB->fetchArray($results);

$tpl->assign('charset', _CHARSET);
$tpl->assign('author', $blog['uname']);
$tpl->assign('sitename', $xoopsConfig['sitename']);
$tpl->assign('description', "");
$tpl->assign('generator', _MI_WEBLOG_NAME);
$tpl->assign('image_url', XOOPS_URL.'/images/logo.gif');
$tpl->assign('datetime', formatTimestamp($blog['created'], "l"));
$tpl->assign('blog_title', $blog['title']);
$tpl->assign('lang_date', _BL_POSTED);
$tpl->assign('lang_author', _BL_AUTHOR);
$tpl->assign('lang_comesfrom', sprintf(_BL_COMESFROM, $xoopsConfig['sitename']));
$tpl->assign('contents', $myts->displayTarea($blog['contents'],1,1,1,1,1,1,1,1,1));
$tpl->assign('site_url', XOOPS_URL);
$tpl->assign('lang_parmalink', _BL_PARMALINK);
$tpl->assign('parmalink', XOOPS_URL.'/modules/'.$xoopsModule->dirname().'/details.php?blog_id='.$blog_id);

$tpl->display('db:weblog_print.html');
?>