<?php
/*
 * $Id: post.php,v 1.6 2003/11/08 07:52:08 wellwine Exp $
 * Copyright (c) 2003 by Hiro SAKAI <http://wellwine.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * You may not change or alter any portion of this comment or credits
 * of supporting developers from this source code or any supporting
 * source code which is considered copyrighted (c) material of the
 * original comment or credit authors.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

include('header.php');
include_once(sprintf('%s/class/xoopstree.php', XOOPS_ROOT_PATH));
include_once(sprintf('%s/modules/%s/class/class.weblog.php', XOOPS_ROOT_PATH, $xoopsModule->dirname()));
include_once(sprintf('%s/modules/%s/class/class.weblogcategories.php', XOOPS_ROOT_PATH, $xoopsModule->dirname()));

$weblog =& Weblog::getInstance();
$weblogcat =& WeblogCategories::getInstance();

function &getEntry($post) {
    $weblog =& Weblog::getInstance();

    $entry = $weblog->newInstance();
    $entry->setVar('blog_id', $post['blog_id']);
    $entry->setVar('user_id', $post['user_id']);
    $entry->setVar('cat_id', $post['cat_id']);
    $entry->setVar('title', $post['title']);
    $entry->setVar('contents', $post['contents']);
    $entry->setVar('private', !empty($post['private']) ? 'Y' : 'N');
    $entry->setVar('dohtml', empty($post['nohtml']) ? 1 : 0);
    return $entry;
}

function weblog_confirm($hiddens, $action, $msg, $submit='')
{
    $submit = ($submit != '') ? trim($submit) : _SUBMIT;
    echo '<div class="confirmMsg"><h4>'.$msg.'</h4><form method="post" action="'.$action.'">';
    foreach ($hiddens as $name => $value) {
        if (is_array($value)) {
            foreach ($value as $caption => $newvalue) {
                echo '<input type="radio" name="'.$name.'" value="'.$newvalue.'" /> '.$caption;
            }
            echo '<br />';
        } else {
            echo '<input type="hidden" name="'.$name.'" value="'.$value.'" />';
        }
    }
    echo '<input type="submit" name="continue" value="'.$submit.'" /></form></div>';
}

if (is_object($xoopsUser)) {
    $currentUser = $xoopsUser;
} else {
    $currentUser =& new XoopsUser();
    $currentUser->setVar('uid', 0);
}
$isAdmin = $currentUser->isAdmin($xoopsModule->mid());
$currentuid = $currentUser->getVar('uid');

// Check to ensure this user can post.
$priv =& xoops_getmodulehandler('priv');
if ($currentuid==0 || (!$isAdmin && ($xoopsModuleConfig['adminonly'] || !$priv->hasPrivilege($currentUser)))) {
    redirect_header(sprintf('%s/modules/%s/index.php', XOOPS_URL, $xoopsModule->dirname()),
                    5, _BL_ANON_CANNOT_POST_SORRY);
    exit();
}

// Save the post
if (!empty($_POST['post'])) {
  $entry =& getEntry($_POST);
  if (strlen($entry->getVar('contents', 'n')) < $xoopsModuleConfig['minentrysize']) {
    // Include the page header
    include(XOOPS_ROOT_PATH.'/header.php');
    weblog_confirm(array('title'=>$entry->getVar('title', 'f'),
                         'contents'=>$entry->getVar('contents', 'f'),
                         'blog_id'=>$entry->getVar('blog_id'),
                         'private'=>$entry->isPrivate(),
                         'nohtml'=>!$entry->doHtml(),
                         'user_id'=>$entry->getVar('user_id'),
                         'cat_id'=>$entry->getVar('cat_id'),
                         'continue'=>1),
                   'post.php',
                   sprintf(_BL_POST_TOO_SMALL, $xoopsModuleConfig['minentrysize'],
                           strlen($entry->getVar('contents', 'n'))),
                   _BL_CONTINUE_EDITING);
    // Include the page header
    include(XOOPS_ROOT_PATH.'/footer.php');
    exit();
  }

  $notification_handler =& xoops_gethandler('notification');
  $pageUri = sprintf('%s/modules/%s/details.php?blog_id=', XOOPS_URL, $xoopsModule->dirname());

  if ($entry->getVar('blog_id') > 0) {
    $e_entry = $weblog->getEntry($entry->getVar('user_id'), $entry->getVar('blog_id'));
    $isEditable = ($e_entry->getVar('user_id')==$currentuid || $isAdmin);
    if ($isEditable) {
      $e_entry->setVar('title', $entry->getVar('title', 'n'));
      $e_entry->setVar('cat_id', $entry->getVar('cat_id'));
      $e_entry->setVar('contents', $entry->getVar('contents', 'n'));
      $e_entry->setVar('private', $entry->getVar('private', 'n'));
      $e_entry->setVar('dohtml', $entry->getVar('dohtml'));
      $ret = $weblog->saveEntry($e_entry);
      if ($ret) {
          $goodPost = true;
      } else {
          $goodPost = false;
      }
    } else {
      $goodPost = false;
    }
    $pageUri .= $entry->getVar('blog_id');
  } else {
    $entry->setVar('created', time());
    $entry->setVar('user_id', $currentuid);
    $ret = $weblog->saveEntry($entry);
    if ($ret) {
        $goodPost = true;
    } else {
        $goodPost = false;
    }
    $pageUri .= $entry->getVar('blog_id');

    // Send notifications only if the entry not private.
    if ($ret && $entry->isPrivate()==false) {
      $notification_handler->triggerEvent ('blog', $xoopsUser->getVar('uid'), 'add',
                                           $extra_tags=array('TITLE'=>$entry->getVar('title'),
                                                             'PAGE_URI'=>$pageUri),
                                           $user_list=array(), $module_id=null,
                                           $omit_user_id=null);
    }
  }

  /*
   * If they did not affect any rows, they were probably trying to update
   * an entry that was not theirs. So check!
   */
  if ($goodPost) {
    redirect_header($pageUri, 2, _BL_ENTRY_POSTED);
    exit();
  } else {
    redirect_header(sprintf('%s/modules/%s/index.php', XOOPS_URL, $xoopsModule->dirname()),
                    5, _BL_ANON_CANNOT_POST_SORRY);
    exit();
  }
} else if (!empty($_POST['delete']) || (!empty($_POST['op']) && $_POST['op'] == 'delete')) {
  $entry =& getEntry($_POST);
  if (!empty($_POST['ok'])) {
    // After delete, return the user to the user's blog they were reading.
    $link = sprintf('%s/modules/%s/index.php?user_id=%d',
                    XOOPS_URL, $xoopsModule->dirname(), $entry->getVar('user_id'));
    $isEditable = ($entry->getVar('user_id')==$currentuid || $isAdmin);
    if ($isEditable) {
      $ret = $weblog->removeEntry($entry->getVar('blog_id'));
      if ($ret) {
        xoops_comment_delete($xoopsModule->getVar('mid'), $entry->getVar('blog_id'));
        xoops_notification_deletebyitem($xoopsModule->getVar('mid'),
                                        'blog_entry', $entry->getVar('blog_id'));
        redirect_header($link, 2 ,_BL_BLOG_DELETED);
      } else {
        redirect_header($link, 5 ,_BL_BLOG_NOT_DELETED);
      }
    } else {
      redirect_header($link, 5 ,_BL_BLOG_NOT_DELETED); // TODO
    }
  } else {
    require(XOOPS_ROOT_PATH.'/header.php');
    xoops_confirm(array('op' => 'delete',
                        'blog_id' => $entry->getVar('blog_id'),
                        'cat_id' => $entry->getVar('cat_id'),
                        'title' => $entry->getVar('title', 'n'),
                        'contents' => $entry->getVar('contents', 'n'),
                        'ok' => 1,
                        'user_id' => $entry->getVar('user_id')),
                  'post.php', sprintf(_BL_CONFIRM_DELETE, stripslashes($entry->getVar('title'))));
    require(XOOPS_ROOT_PATH.'/footer.php');
  }
} else {
  // Edit/Create/Preview the post
  $blog_id=!empty($_GET['blog_id']) ? $_GET['blog_id'] : 0;
  if ($blog_id>0 && empty($_POST['preview'])) {
    $entry =& $weblog->getEntry($currentuid, $blog_id);
    $selbox = $weblogcat->getMySelectBox($entry->getVar('cat_id'));
  } else if (!empty($_POST['preview']) || !empty($_POST['continue'])) {
    $_POST['title'] = stripslashes($_POST['title']);
    $_POST['contents'] = stripslashes($_POST['contents']);
    $entry =& getEntry($_POST);
    $selbox = $weblogcat->getMySelectBox($entry->getVar('cat_id'));
  } else {
    $entry = $weblog->newInstance();
    $entry->setVar('user_id', -1);
    $selbox = $weblogcat->getMySelectBox();
  }
  $xoopsOption['template_main'] = 'weblog_post.html';
  include_once XOOPS_ROOT_PATH."/include/xoopscodes.php";

  // Include the page header
  include(XOOPS_ROOT_PATH.'/header.php');
  
  // Generate our form promatically
  include_once XOOPS_ROOT_PATH."/class/xoopsformloader.php";
  $blog_form = new XoopsThemeForm(_BL_POST, 'blogform', "post.php");
  $blog_form->addElement(new XoopsFormHidden('user_id',$entry->getVar('user_id')));
  $blog_form->addElement(new XoopsFormHidden('blog_id',$entry->getVar('blog_id')));
  if ($xoopsModuleConfig['minentrysize'] > 0) {
    $blog_form->addElement(new XoopsFormLabel('',sprintf(_BL_POST_MUST_BE,
                                                         $xoopsModuleConfig['minentrysize'])));
  }
  $blog_form->addElement(new XoopsFormText(_BL_TITLE,'title',
                                           $xoopsModuleConfig['editorwidth'],
                                           80, $entry->getVar('title', 'e')), true);
  //$selbox_tray = new XoopsFromElementTray('_BL_CATEGORY', '');
  $blog_form->addElement(new XoopsFormLabel(_BL_CATEGORY, $selbox));
  $blog_form->addElement(new XoopsFormDhtmlTextArea(_BL_CONTENTS,'contents',
                                                    $entry->getVar('contents', 'e'),
                                                    $xoopsModuleConfig['editorheight'],
                                                    $xoopsModuleConfig['editorwidth']), true);

    // options check box
    $checkbox_tray = new XoopsFormElementTray(_BL_OPTIONS ,'<br />');
    $checkbox = new XoopsFormCheckBox('', 'nohtml', !$entry->doHtml());
    $checkbox->addOption('nohtml', _BL_DISABLEHTML);
    $checkbox_tray->addElement($checkbox);
    $checkbox = new XoopsFormCheckBox('', 'private', $entry->isPrivate());
    $checkbox->addOption('private', _BL_PRIVATE);
    $checkbox_tray->addElement($checkbox);
    $blog_form->addElement($checkbox_tray);

  $button_tray = new XoopsFormElementTray('' ,'');
  if ($entry->getVar('blog_id') > 0 && $isAdmin || $currentuid == $entry->getVar('user_id')) {
    $button_tray->addElement(new XoopsFormButton('','delete', _BL_DELETE_BUTTON, 'submit'));
  }
  $button_tray->addElement(new XoopsFormButton('', 'preview', _BL_PREVIEW_BUTTON, 'submit'));
  $button_tray->addElement(new XoopsFormButton('', 'post', _BL_POST_BUTTON, 'submit'));
  $blog_form->addElement($button_tray);

  $xoopsTpl->assign('form', $blog_form->render());

  if (!empty($_POST['preview'])) {
    $use_avatar = 0;
    $avatar_img = '';
    $avatar_width = 0;
    
    if ($xoopsModuleConfig['showavatar']) {
      $avatar = $currentUser->getVar('user_avatar', 'E');
      if (!empty($avatar) && $avatar != 'blank.gif') {
        $use_avatar = 1;
        $avatar_img = sprintf('%s/uploads/%s', XOOPS_URL, $avatar);
        $dimension = getimagesize($avatar_img);
        $avatar_width = $dimension[0];
      }
    }

    $xoopsTpl->assign('use_avatar', $use_avatar);
    $xoopsTpl->assign('avatar_width', $avatar_width);
    $xoopsTpl->assign('avatar_img', $avatar_img);
    $xoopsTpl->assign('preview', $entry->getVar('contents', 's'));
    $xoopsTpl->assign('title', $entry->getVar('title', 's'));
    $xoopsTpl->assign('is_preview',1);
    $xoopsTpl->assign('sample_date', formatTimestamp(time(),
                                                     $xoopsModuleConfig['dateformat'],
                                                     $xoopsConfig['default_TZ']));
  } else {
    $xoopsTpl->assign('is_preview',0);
    $xoopsTpl->assign('title','');
    $xoopsTpl->assign('preview','');
    $xoopsTpl->assign('sample_date','');
  }
  
  // Include the page footer
  include(XOOPS_ROOT_PATH.'/footer.php');
}
?>