<?php

define("XCUBE_TOKEN_TYPE_SINGLE",1);
define("XCUBE_TOKEN_TYPE_MULTI",2);

/**
 * This is suggestion of a simple action form.
 * We do not force a module developer to use this.
 * You can learn more full-scale action forms from JAVA and .NET and other PHP.
 * And, you must use auto-generating tool when you need to ActionForm that is sub-class of this class.
 */
class XCube_ActionForm
{
	/**
	 * Array
	 */
	var $mFormProperties;

	/**
	 * Array
	 */
	var $mFieldProperties;
	
	/**
	 * NOTICE: This is temporary until we will decide the method of managing error.
	 */
	var $mErrorFlag=false;
	
	var $mErrorMessages=array();

	function XCube_ActionForm()
	{
	}
	
	function prepare()
	{
	}
	
	function setVar($key,$val)
	{
		//
		// TODO Follow about array.
		//
		if(isset($this->mFormProperties[$key]))
			$this->mFormProperties[$key]->setValue($val);
	}
	
	function getVar($key,$index=null)
	{
		return isset($this->mFormProperties[$key]) ? $this->mFormProperties[$key]->getValue($index) : null;
	}
	
	/**
	 * Return form properties of this member property.
	 * @return XCube_AbstractProperty[]
	 */
	function &getFormProperties()
	{
		return $this->mFormProperties;
	}

	function fetch()
	{
		foreach(array_keys($this->mFormProperties) as $name) {
			$this->mFormProperties[$name]->fetch();
		}
	}

	function validate()
	{
		foreach(array_keys($this->mFormProperties) as $name) {
			if(isset($this->mFieldProperties[$name])) {
				$this->mFieldProperties[$name]->validate($this->getVar($name));
			}
		}

		//
		// If this class has original validation methods, call it.
		//
		foreach(array_keys($this->mFormProperties) as $name) {
			$methodName="validate".ucfirst($name);
			if(method_exists($this,$methodName)) {
				// call_user_func(array($this,$methodName));
				$this->$methodName();
			}
		}
	}

	function hasError()
	{
		return count($this->mErrorMessages)>0;
	}
	
	function addErrorMessage($message)
	{
		$this->mErrorMessages[]=$message;
	}
	
	function getErrorMessages()
	{
		return $this->mErrorMessages;
	}
}

/**
 * This class depends on POST or GET.
 *
 * 1) Must define getTokenErrorMessage()
 */
class XCube_TokenActionForm extends XCube_ActionForm
{
	var $mToken = null;

	function prepare()
	{
		parent::prepare();
		if(xoops_getenv('REQUEST_METHOD')=="GET") {
			$this->_setupToken();
		}
		else {
			$this->_fetchToken();
		}
	}

	function _setupToken()
	{
		$tokenHandler=&$this->_createTokenHandler();

		if($tokenHandler==null)
			die();	// TODO

		$this->mToken=&$tokenHandler->create($this->getTokenName());
		$tokenHandler->register($this->mToken);
	}
	
	function _fetchToken()
	{
		$tokenHandler=&$this->_createTokenHandler();

		if($tokenHandler==null)
			die();	// TODO

		$this->mToken=&$tokenHandler->fetch($this->getTokenName());
	}
	
	function &_createTokenHandler()
	{
		$tokenHandler=null;
		if($this->getTokenType==XCUBE_TOKEN_TYPE_SINGLE) {
			$tokenHandler=new XoopsSingleTokenHandler();
		}
		elseif($this->getTokenType==XCUBE_TOKEN_TYPE_MULTI) {
			$tokenHandler=new XoopsMultiTokenHandler();
		}
		
		return $tokenHandler;
	}
	
	function valite()
	{
		parent::validate();
		
		$tokenHandler=&$this->_createTokenHandler();

		if($tokenHandler!=null && is_object($this->mToken)) {
			if($tokenHandler->validate($this->mToken)) {
				//
				// Success
				//
				return;
			}
			else {
				$tokenHandler->unregister($this->mToken);
			}
		}

		$this->addErrorMessage($this->getTokenErrorMessage());
		$this->_setupToken();
	}

	/**
	 * Return string as token name.
	 * @return string
	 */
	function getTokenName()
	{
		return get_class($this);
	}

	/**
	 * Return XCUBE_TOKEN_TYPE_SINGLE or XCUBE_TOKEN_TYPE_MULTI
	 * @return XCUBE_TOKEN_TYPE_SINGLE or XCUBE_TOKEN_TYPE_MULTI
	 */
	function getTokenType()
	{
		return XCUBE_TOKEN_TYPE_MULTI;
	}
	
	/**
	 * Return string as error message about one-time token.
	 * @return string
	 */
	function getTokenErrorMessage()
	{
		return "Ticket Error";
	}
}

class XCube_AbstractProperty
{
	var $mName=null;
	var $mValue=null;
	
	function XCube_AbstractProperty($name)
	{
		$this->mName=$name;
	}

	function setValue($val)
	{
		$this->mValue=$val;
	}

	function getValue($index=null)
	{
		return $this->mValue;
	}

	function fetch()
	{
		if(isset($_REQUEST[$this->mName])&&!is_array($_REQUEST[$this->mName])) {
		    if (get_magic_quotes_gpc()) {
				$this->mValue=stripslashes($_REQUEST[$this->mName]);
			}
			else {
				$this->mValue=$_REQUEST[$this->mName];
			}
		}
		else
			$this->mValue=null;
	}
}

class XCube_AbstractArrayProperty extends XCube_AbstractProperty
{
	function XCube_AbstractArrayProperty($name)
	{
		parent::XCube_AbstractProperty($name);
		$this->mValue=array();
	}
	
	function fetch()
	{
		if(isset($_REQUEST[$this->mName])&&is_array($_REQUEST[$this->mName])) {
			foreach($_REQUEST[$this->mName] as $key=>$val) {
			    if (get_magic_quotes_gpc()) {
					$this->mValue[$key]=stripcslashes($val);
				}
				else {
					$this->mValue[$key]=$val;
				}
			}
		}
		else
			$this->mValue=array();
	}

	function getValue($index=null)
	{
		if($index==null)
			return $this->mValue;

		return $this->mValue[$index];
	}

}

class XCube_IntProperty extends XCube_AbstractProperty
{
	function fetch()
	{
		parent::fetch();
		if(strlen($this->mValue)>0) {
			$this->mValue=intval($this->mValue);
		}
		else {
			$this->mValue=null;
		}
	}
}

class XCube_IntArrayProperty extends XCube_AbstractArrayProperty
{
	function fetch()
	{
		parent::fetch();
		foreach(array_keys($this->mValue) as $key) {
			if(strlen($this->mValue[$key])>0) {
				$this->mValue[$key]=intval($this->mValue[$key]);
			}
			else {
				$this->mValue[$key]=null;
			}
		}
	}
}

class XCube_FloatProperty extends XCube_AbstractProperty
{
	function fetch()
	{
		parent::fetch();
		$this->mValue=floatval($this->mValue);
	}
}

class XCube_FloatArrayProperty extends XCube_AbstractArrayProperty
{
	function fetch()
	{
		parent::fetch();
		foreach(array_keys($this->mValue) as $key) {
			$this->mValue[$key]=floatval($this->mValue[$key]);
		}
	}
}

class XCube_StringProperty extends XCube_AbstractProperty
{
	function fetch()
	{
		parent::fetch();
		if(preg_match_all("/[\\x00-\\x1f]/",$this->mValue,$matches,PREG_PATTERN_ORDER)) {
			foreach($matches[0] as $match) {
				die("Get control code :" . ord($match));
			}
		}
	}
}

class XCube_StringArrayProperty extends XCube_AbstractArrayProperty
{
	function fetch()
	{
		parent::fetch();
		foreach(array_keys($this->mValue) as $key) {
			if(preg_match_all("/[\\x00-\\x1f]/",$this->mValue[$key],$matches,PREG_PATTERN_ORDER)) {
				foreach($matches[0] as $match) {
					die("Get control code :" . ord($match));
				}
			}
		}
	}
}

class XCube_TextProperty extends XCube_AbstractProperty
{
	function fetch()
	{
		parent::fetch();
		$matches=array();
		$allow_codes=array(9,10,13);

		if(preg_match_all("/[\\x00-\\x09]|[\\x0b-\\x0c]|[\\x0e-\\x1f]/",$this->mValue,$matches,PREG_PATTERN_ORDER)) {
			foreach($matches[0] as $match) {
				if(!in_array(ord($match),$allow_codes) && ord($match)<32)
					die("Get control code :" . ord($match));
			}
		}
	}
}

class XCube_FieldProperty
{
	var $mForm;
	
	var $mDepends;
	var $mMessages;
	var $mVariables;

	function XCube_FieldProperty(&$form)
	{
		$this->mForm=&$form;
	}
	
	function setDependsByArray($dependsArr)
	{
		foreach($dependsArr as $dependName){
			$instance =& XCube_DependClassFactory::factoryClass($dependName);
			if($instance!==null)
				$this->mDepends[]=&$instance;

			unset($instance);
		}
	}
	
	function addMessage($name,$message)
	{
		if(func_num_args()>=2) {
			$args=func_get_args();
			$this->mMessages[$args[0]]['message']=$args[1];
			for($i=0;isset($args[$i+2]);$i++) {
				$this->mMessages[$args[0]]['args'][$i]=$args[$i+2];
			}
		}
	}
	
	function renderMessage($name)
	{
		if(!isset($this->mMessages[$name]))
			return null;

		$message=$this->mMessages[$name]['message'];

		if(isset($this->mMessages[$name]['args'])) {
			for($i=0;$i<count($this->mMessages[$name]['args']);$i++) {
				$message=str_replace("{".$i."}",$this->mMessages[$name]['args'][$i],$message);
			}
		}
		
		return $message;
	}

	function addVar($name,$value)
	{
		$this->mVariables[$name]=$value;
	}
	
	function validate($val)
	{
		foreach($this->mDepends as $depend) {
			if(!$depend->check($val,$this->mVariables)) {
				// Error
				// NOTICE: This is temporary until we will decide the method of managing error.
				$this->mForm->mErrorFlag=true;
				
				// TEST!!
				$this->mForm->addErrorMessage($this->renderMessage($depend->getName()));
			}
			else {
				// OK
			}
		}
	}
}

class XCube_DependClassFactory
{
	function &factoryClass($dependName)
	{
		$ret=null;

		// or switch?
		$class_name="XCube_".ucfirst($dependName)."Depend";
		if(class_exists($class_name)) {
			$ret=new $class_name();
		}

		return $ret;
	}
}

class XCube_AbstractDepend
{
	var $mName="";
	
	function XCube_AbstractDepend()
	{
	}
	
	function check($val,$vars)
	{
		if(is_array($val))
			return $this->_checkAsArray($val,$vars);
		else
			return $this->_check($val,$vars);
	}
	
	/**
	 @access protected
	 */
	function _check($val,$vars)
	{
		return false;
	}
	
	/**
	 @access protected
	 */
	function _checkAsArray($val,$vars)
	{
		return false;
	}
	
	function getName()
	{
		return $this->mName;
	}
}

class XCube_RequiredDepend extends XCube_AbstractDepend
{
	var $mName="required";
	
	function _check($val,$vars)
	{
		return strlen($val)!=0;
	}
	
	function _checkAsArray($val,$vars)
	{
		if(!count($val))
			return false;

		$flag = true;
		foreach($val as $i) {
			$flag &= (strlen($i)!=0);
		}

		return $flag;
	}
}

class XCube_MinlengthDepend extends XCube_AbstractDepend
{
	var $mName="minlength";
	
	function _check($val,$vars)
	{
		if(!empty($val))
			return strlen($val)>=$vars['minlength'];
		else
			return true;
	}

	function _checkAsArray($val,$vars)
	{
		if(!count($val))
			return false;

		$flag = true;
		foreach($val as $i) {
			if(!empty($i))
				$flag&=(strlen($i)>=$vars['minlength']);
		}
		
		return $flag;
	}
}

class XCube_MaxlengthDepend extends XCube_AbstractDepend
{
	var $mName="maxlength";
	
	function _check($val,$vars)
	{
		if(!empty($val))
			return strlen($val)<=$vars['maxlength'];
		else
			return true;
	}

	function _checkAsArray($val,$vars)
	{
		if(!count($val))
			return false;

		$flag = true;
		foreach($val as $i) {
			if(!empty($i))
				$flag&=(strlen($i)<=$vars['maxlength']);
		}

		return $flag;
	}
}

class XCube_MinDepend extends XCube_AbstractDepend
{
	var $mName="min";
	
	function _check($val,$vars)
	{
		if(!empty($val))
			return $val>=$vars['min'];
		else
			return true;
	}

	function _checkAsArray($val,$vars)
	{
		if(!count($val))
			return false;

		$flag = true;
		foreach($val as $i) {
			if(!empty($i))
				$flag&=($i>=$vars['min']);
		}

		return $flag;
	}
}

class XCube_MaxDepend extends XCube_AbstractDepend
{
	var $mName="max";
	
	function _check($val,$vars)
	{
		if(!empty($val))
			return $val<=$vars['max'];
		else
			return true;
	}

	function _checkAsArray($val,$vars)
	{
		if(!count($val))
			return false;

		$flag = true;
		foreach($val as $i) {
			if(!empty($i))
				$flag&=($i<=$vars['max']);
		}

		return $flag;
	}
}

class XCube_IntRangeDepend extends XCube_AbstractDepend
{
	var $mName="intRange";
	
	function _check($val,$vars)
	{
		if(!empty($val))
			return ($val>=$vars['min'])&&($val<=$vars['max']);
		else
			return true;
	}

	function _checkAsArray($val,$vars)
	{
		if(!count($val))
			return false;

		$flag = true;
		foreach($val as $i) {
			if(!empty($i))
				$flag&=(($i>=$vars['min'])&&($i<=$vars['max']));
		}

		return $flag;
	}
}

?>