<?php
// $Id: Misc_OnlineAction.class.php,v 1.1.2.2 2005/12/26 11:24:16 minahito Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //

define ("MISC_ONLINE_PER_PAGE",20);

class Misc_OnlineAction extends MiscAction
{
	var $mOnlineUsers=array();
	
	function getDefaultView(&$controller,&$xoopsUser)
	{
		$start=isset($_GET['start']) ? intval($_GET['start']) : 0;
		
		$onlineHandler=&xoops_gethandler('online');
		$onlineTotal=$onlineHandler->getCount();
		$limit = ($onlineTotal>MISC_ONLINE_PER_PAGE) ? MISC_ONLINE_PER_PAGE : $onlineTotal;
		
		// bad
		$criteria=new CriteriaCompo();
		$criteria->setLimit($limit);
		$criteria->setStart($start);
		
		$onlineInfos=&$onlineHandler->getAll($criteria);
		$count=count($onlineInfos);
		
		$moduleHandler=&xoops_gethandler('module');
		$modules=&$moduleHandler->getList(new Criteria('isactive',1));
		
		foreach($onlineInfos as $info) {
			$user=array();
			$user['onlineInfo']=&$info;
			if($info['online_uid']) {
				$user['user']=new XoopsUser($info['online_uid']);
			}
			else {
				$user['user']=null;
			}
			
			$user['module'] = ($info['online_module'] > 0) ? $modules[$info['online_module']] : null;
			
			$this->mOnlineUsers[]=&$user;

			unset($user);
			unset($info);
		}

		return MISC_FRAME_VIEW_INDEX;
	}
	
	function executeViewIndex(&$controller,&$xoopsUser,&$renderSystem)
	{
		$renderSystem->setTemplateName("legacy_misc_online.html");
		$renderSystem->setAttribute("onlineUsers",$this->mOnlineUsers);
	}
}

?>