<?php
/**
 * @version $Id: LegacyModuleInfoAction.class.php,v 1.1.2.2 2005/12/21 04:08:12 minahito Exp $
 */

/**
 * This action will show the information of a module specified to user.
 */
class LegacyModuleInfoAction extends LegacyAdminAction
{
	/**
	 * XoopsModule instance specified.
	 */
	var $mModuleObject = null;
	var $mInstalledFlag = false;

	function getDefaultView(&$controller, &$xoopsUser)
	{
		$dirname = $_GET['dirname'];
		if (!preg_match("/^[a-z\_]+$/i", $dirname)) {
			return LEGACY_ADMIN_FRAME_VIEW_ERROR;
		}

		if (!is_dir(XOOPS_MODULE_PATH . "/" . $dirname)) {
			return LEGACY_ADMIN_FRAME_VIEW_ERROR;
		}

		$moduleHandler =& xoops_gethandler('module');
		$this->mModuleObject =& $moduleHandler->getByDirname($dirname);

		//
		// If a module is installed, load modinfo and go to special displaying.
		//
		if (is_object($this->mModuleObject)) {
			$this->mModuleObject->loadAdminMenu();
			$this->mModuleObject->loadInfo($dirname);
			$this->mInstalledFlag = true;
		}
		else {
			$this->mModuleObject =& $moduleHandler->create();
			$this->mModuleObject->loadInfoAsVar($dirname);
			$this->mInstalledFlag = false;
		}

		return LEGACY_ADMIN_FRAME_VIEW_SUCCESS;
	}
	
	function executeViewSuccess(&$controller, &$xoopsUser, &$renderer)
	{
		$renderer->setTemplateName("module_information.html");
		$renderer->setAttribute('module', $this->mModuleObject);
		$renderer->setAttribute('installed', $this->mInstalledFlag);
	}

	function executeViewError(&$controller, &$xoopsUser, &$renderer)
	{
		XCube_Utils::redirectHeader('./index.php?action=ModuleList', 1, "*Module not found*");
	}
}

?>