<?php

require_once XOOPS_ROOT_PATH."/class/XCube_PageNavigator.class.php";
require_once XOOPS_ROOT_PATH."/modules/user/admin/forms/UserActionFilterForm.class.php";

class UserDefaultAction extends UserAction
{
	var $mUserObjects=array();
	var $mFilter=null;
	var $mPageNavi=null;

	function isSecure()
	{
		return true;
	}

	function getDefaultView(&$controller,&$xoopsUser)
	{
		$this->mFilter=new UserActionFilterForm();
		$this->mFilter->fetch();

		$userHandler=&xoops_gethandler('user');
		$total=&$userHandler->getCount();

		$this->mPageNavi=new XCube_PageNavigator("./index.php",$total,XCUBE_PAGENAVI_START | XCUBE_PAGENAVI_PERPAGE);	// TODO get controller->getUrl() ?
		$this->mPageNavi->fetch();

		$criteria=new Criteria("uid",0,">");	// dmy

		$criteria->setSort($this->mFilter->getSort());
		$criteria->setOrder($this->mFilter->getOrder());
		$criteria->setStart($this->mPageNavi->getStart());
		$criteria->setLimit($this->mPageNavi->getPerpage());

		$this->mUserObjects=$userHandler->getObjects($criteria);

		return USER_FRAME_VIEW_INDEX;
	}

	function executeViewError(&$controller,&$xoopsUser,&$renderSystem)
	{
	}

	function executeViewIndex(&$controller,&$xoopsUser,&$renderSystem)
	{
		$renderSystem->setTemplateName("user_list.html");
		$renderSystem->setAttribute("users",$this->mUserObjects);
		$renderSystem->setAttribute("pageNavi",$this->mPageNavi);
	}
}

?>