<?php

require_once XOOPS_ROOT_PATH."/modules/user/admin/forms/GroupEditForm.class.php";

class UserGroupEditAction extends UserAction
{
	var $mGroup = null;
	var $mGroupHandler = null;
	var $mActionForm=null;

	function isSecure()
	{
		return true;
	}

	function getDefaultView(&$controller,&$xoopsUser)
	{
		$this->_proccessActionForm();
		$this->_proccessObject($controller);

		$this->mActionForm->load($this->mGroup);

		return USER_FRAME_VIEW_INPUT;
	}
	
	function execute(&$controller,&$xoopsUser)
	{
		$this->_proccessActionForm();
		$this->_proccessObject($controller);

		//
		// If image is no, the data has to continue to keep his value.
		//
		$this->mActionForm->load($this->mGroup);

		$this->mActionForm->fetch();
		$this->mActionForm->validate();

		if($this->mActionForm->hasError())
			return USER_FRAME_VIEW_INPUT;
			
		$this->mActionForm->update($this->mGroup);

		return $this->mGroupHandler->insert($this->mGroup) ? USER_FRAME_VIEW_SUCCESS
		                                                     : USER_FRAME_VIEW_ERROR;
	}

	function _proccessObject(&$controller)
	{
		$groupId=isset($_REQUEST['groupid']) ? intval($_REQUEST['groupid']) : 0;
		$this->mGroupHandler =& xoops_gethandler('group');
		$this->mGroup =& $this->mGroupHandler->get($groupId);
		if (!is_object($this->mGroup)) {
			$this->mGroup =& $this->mGroupHandler->create();
		}
	}
	
	function _proccessActionForm()
	{
		$this->mActionForm =& new User_GroupEditForm();
		$this->mActionForm->prepare();
	}

	function executeViewInput(&$controller,&$xoopsUser,&$renderSystem)
	{
		$renderSystem->setTemplateName("group_edit.html");
		$renderSystem->setAttribute("actionForm",$this->mActionForm);
	}

	function executeViewSuccess(&$controller,&$xoopsUser,&$renderSystem)
	{
		XCube_Utils::redirectHeader("index.php?action=GroupList", 1, "*SUCCESS*");
	}

	function executeViewError(&$controller,&$xoopsUser,&$renderSystem)
	{
		XCube_Utils::redirectHeader("index.php?action=GroupList", 1, "*ERROR*");
	}
}

?>