<?php

require_once XOOPS_ROOT_PATH."/class/XCube_ActionForm.class.php";
require_once XOOPS_ROOT_PATH."/modules/user/class/UserFormFile.class.php";

/**
 * This class is generated by makeActionForm tool.
 * @auchor makeActionForm
 */
class RankEditForm extends XCube_ActionForm 
{
	/**
	 * Image file name.
	 * Because of this does not set to property is that this is never fetched by $_REQUEST.
	 */
	var $mImageFileName;
	
	var $mImageFile;
	
	function RankEditForm()
	{
		parent::XCube_ActionForm();
		$this->mImageFile = new UserFormFile('rank_image');
	}
	
	function prepare()
	{
		// set properties
		$this->mFormProperties['rank_id']=new XCube_IntProperty('rank_id');
		$this->mFormProperties['rank_title']=new XCube_StringProperty('rank_title');
		$this->mFormProperties['rank_min']=new XCube_IntProperty('rank_min');
		$this->mFormProperties['rank_max']=new XCube_IntProperty('rank_max');
		$this->mFormProperties['rank_special']=new XCube_IntProperty('rank_special');

		// set fields
		$this->mFieldProperties['rank_title']=new XCube_FieldProperty($this);
		$this->mFieldProperties['rank_title']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['rank_title']->addMessage("required",_MD_A_USER_ERROR_REQUIRED,_MD_A_USER_LANG_RANK_TITLE,"50");
		$this->mFieldProperties['rank_title']->addVar("maxlength",50);

		$this->mFieldProperties['rank_min']=new XCube_FieldProperty($this);
		$this->mFieldProperties['rank_min']->setDependsByArray(array('required','min'));
		$this->mFieldProperties['rank_min']->addMessage("required",_MD_A_USER_ERROR_REQUIRED,_MD_A_USER_LANG_RANK_MIN,"0");
		$this->mFieldProperties['rank_min']->addMessage("min",_MD_A_USER_ERROR_MIN,_MD_A_USER_LANG_RANK_MIN,"0");
		$this->mFieldProperties['rank_min']->addVar("min",0);

		$this->mFieldProperties['rank_max']=new XCube_FieldProperty($this);
		$this->mFieldProperties['rank_max']->setDependsByArray(array('required','min'));
		$this->mFieldProperties['rank_max']->addMessage("required",_MD_A_USER_ERROR_REQUIRED,_MD_A_USER_LANG_RANK_MAX,"0");
		$this->mFieldProperties['rank_max']->addMessage("min",_MD_A_USER_ERROR_MIN,_MD_A_USER_LANG_RANK_MAX,"0");
		$this->mFieldProperties['rank_max']->addVar("min",0);

		$this->mFieldProperties['rank_special']=new XCube_FieldProperty($this);
		$this->mFieldProperties['rank_special']->setDependsByArray(array('intRange'));
		$this->mFieldProperties['rank_special']->addMessage("intRange",_MD_A_USER_ERROR_INJURY_SPECIAL);
		$this->mFieldProperties['rank_special']->addVar("min",0);
		$this->mFieldProperties['rank_special']->addVar("max",1);
	}

	function fetch()
	{
		parent::fetch();
		$this->mImageFile->fetch();
	}
	
	function validate()
	{
		parent::validate();
		if($this->getVar('max')<$this->getVar('min')) {
			$this->addErrorMessage(_MD_A_USER_ERROR_INJURY_MIN_MAX);
		}

		//
		// Check file
		//
		if($this->mImageFile->hasUploadFile()) {
			//
			// Add code
			//
			if(!$this->mImageFile->checkFormat())
				$this->addErrorMessage(_MD_A_USER_ERROR_WRONG_FORMAT);
		}
		elseif(!$this->hasError() && $this->mImageFileName==null) {
			//
			// If we have no filename and no file uploaded, the validation is error.
			//
			$this->addErrorMessage(_MD_A_USER_ERROR_NO_UPLOAD_FILE);
		}
	}

	/**
	 * @param $master UserRankObject
	 */
	function load(&$master)
	{
		$this->setVar('rank_id',$master->getProperty('rank_id'));
		$this->setVar('rank_title',$master->getProperty('rank_title'));
		$this->setVar('rank_min',$master->getProperty('rank_min'));
		$this->setVar('rank_max',$master->getProperty('rank_max'));
		$this->setVar('rank_special',$master->getProperty('rank_special'));
		
		//
		// We set master.rankimage to original property.
		//
		$this->mImageFileName=$master->getProperty('rank_image');
	}

	/**
	 * @param $master UserRankObject
	 */
	function update(&$master)
	{
		$master->setVar('rank_id',$this->getVar('rank_id'));
		$master->setVar('rank_title',$this->getVar('rank_title'));
		$master->setVar('rank_min',$this->getVar('rank_min'));
		$master->setVar('rank_max',$this->getVar('rank_max'));
		$master->setVar('rank_special',$this->getVar('rank_special'));

		if($this->mImageFile->hasUploadFile()) {
			// TODO Check error
			$this->mImageFile->saveAsRandBody(XOOPS_UPLOAD_PATH,"rank");
			$master->setVar('rank_image',$this->mImageFile->getFileName());
		}
		else {
			$master->setVar('rank_image',$this->mImageFileName);
		}
	}
}


?>
