<?php

require_once XOOPS_ROOT_PATH."/class/XCube_ActionStrategy.class.php";

define ("USER_MODULE_PERFORM_SUCCESS",1);
define ("USER_MODULE_PERFORM_FAIL",2);
define ("USER_MODULE_INIT_SUCCESS",3);

class UserModuleFrame extends XCube_ActionStrategy
{
	var $mActionName="";
	var $mAction;
	
	var $mActionForm=null;
	
	function UserModuleFrame(&$action)
	{
		$this->mAction=&$action;
	}
	
	function prepare(&$controller)
	{


	}

	function execute(&$controller)
	{
		global $xoopsTpl;

		$xoopsUser=&$controller->getXoopsUser();
		if($this->mAction->isSecure()&&!is_object($xoopsUser)){
			XCube_Utils::redirectHeader(XOOPS_URL,1);
		}
		
		$this->mAction->prepare($xoopsUser);
		
		if(!$this->mAction->isPermission($xoopsUser)) {
			XCube_Utils::redirectHeader(XOOPS_URL,1);
		}

		$formFlag=USER_MODULE_INIT_SUCCESS;
		$master=&$this->mAction->getMasterForActionForm();
		if($this->mAction->isDependsOnActionForm()) {
			$this->mActionForm=&$this->mAction->getActionForm();
			$formFlag=$this->_processActionForm($master);
		}

		switch($formFlag) {
			case USER_MODULE_PERFORM_SUCCESS:
				$this->mAction->doSuccess($this->mActionForm,$master);
				$this->mAction->executePerformSuccessView($this->mActionForm,$xoopsUser,$controller->mRenderSystem);
				break;

			case USER_MODULE_PERFORM_FAIL:
				$this->mAction->executePerformFailView($this->mActionForm,$xoopsUser,$controller->mRenderSystem);
				break;

			case USER_MODULE_INIT_SUCCESS:
				$this->mAction->executeInitSuccessView($this->mActionForm,$xoopsUser,$controller->mRenderSystem);
				break;
		}
	}
	
	function _processActionForm(&$master)
	{
		$this->mActionForm->prepare();

		if(xoops_getenv("REQUEST_METHOD")=="POST") {
			$this->mActionForm->fetch();
			$this->mActionForm->validate();
			if($this->mActionForm->hasError()) {
				return USER_MODULE_PERFORM_FAIL;
			}
			else {
				$this->mActionForm->update($master);
				return USER_MODULE_PERFORM_SUCCESS;
			}
		}
		else {
			$this->mActionForm->load($master);
			return USER_MODULE_INIT_SUCCESS;
		}
	}
}

?>