<?php
// $Id: userinfo.php,v 1.1.2.7 2005/12/30 08:29:06 minahito Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //

require_once '../../mainfile.php';
require_once XOOPS_ROOT_PATH."/header.php";

require_once XOOPS_ROOT_PATH.'/class/module.textsanitizer.php';
require_once XOOPS_ROOT_PATH . '/modules/system/constants.php';

$uid = intval($_GET['uid']);
if ($uid <= 0) {
	redirect_header('index.php', 3, _US_SELECTNG);
	exit();
}

$gpermHandler = & xoops_gethandler( 'groupperm' );
$groups = is_object($xoopsUser) ? $xoopsUser->getGroups() : XOOPS_GROUP_ANONYMOUS;

$isAdmin = $gpermHandler->checkRight( 'system_admin', XOOPS_SYSTEM_USER, $groups);			// isadmin is true if user has 'edit users' admin rights

if ($xoopsUser) {
	if ($uid == $xoopsUser->getVar('uid')) {
		$config_handler =& xoops_gethandler('config');
		$xoopsConfigUser =& $config_handler->getConfigsByCat(XOOPS_CONF_USER);
		$xoopsOption['template_main'] = 'user_userinfo.html';

		$xoopsTpl->assign('user_ownpage', true);
		if ($xoopsConfigUser['self_delete'] == 1) {
			$xoopsTpl->assign('user_candelete', true);
		} else {
			$xoopsTpl->assign('user_candelete', false);
		}
		$thisUser =& $xoopsUser;
	} else {
		$member_handler =& xoops_gethandler('member');
		$thisUser =& $member_handler->getUser($uid);
		if (!is_object($thisUser) || !$thisUser->isActive() ) {
			redirect_header("index.php",3,_US_SELECTNG);
			exit();
		}
		$xoopsOption['template_main'] = 'user_userinfo.html';
		include XOOPS_ROOT_PATH.'/header.php';
		$xoopsTpl->assign('user_ownpage', false);
	}
} else {
	$member_handler =& xoops_gethandler('member');
	$thisUser =& $member_handler->getUser($uid);
	if (!is_object($thisUser) || !$thisUser->isActive()) {
		redirect_header("index.php",3,_US_SELECTNG);
		exit();
	}
	$xoopsOption['template_main'] = 'user_userinfo.html';
	include(XOOPS_ROOT_PATH.'/header.php');
	$xoopsTpl->assign('user_ownpage', false);
}
$myts =& MyTextSanitizer::getInstance();
if ( is_object($xoopsUser) && $isAdmin ) {
	$xoopsTpl->assign('user_uid', $thisUser->getVar('uid'));
}
$xoopsTpl->assign('lang_allaboutuser', sprintf(_US_ALLABOUT,$thisUser->getVar('uname')));
$xoopsTpl->assign('user_extrainfo', $myts->makeTareaData4Show($thisUser->getVar('bio', 'N'),0,1,1));
$xoopsTpl->assign('user_joindate', formatTimestamp($thisUser->getVar('user_regdate'),'s'));
$xoopsTpl->assign('lang_more', _US_MOREABOUT);
$xoopsTpl->assign('lang_myinfo', _US_MYINFO);
$xoopsTpl->assign('lang_notregistered', _US_NOTREGISTERED);

$xoopsTpl->assign('user_signature', $myts->makeTareaData4Show($thisUser->getVar('user_sig', 'N'),0,1,1));

if ($thisUser->getVar('user_viewemail') == 1) {
	$xoopsTpl->assign('user_email', $thisUser->getVar('email', 'E'));
} else {
	if (is_object($xoopsUser)) {
	 	// All admins will be allowed to see emails, even those that are not allowed to edit users (I think it's ok like this)
		if ($xoopsUserIsAdmin || ($xoopsUser->getVar("uid") == $thisUser->getVar("uid"))) {
			$xoopsTpl->assign('user_email', $thisUser->getVar('email', 'E'));
		} else {
			$xoopsTpl->assign('user_email', '&nbsp;');
		}
	}
}
if (is_object($xoopsUser)) {
	$xoopsTpl->assign('user_pmlink', "<a href=\"javascript:openWithSelfMain('".XOOPS_URL."/pmlite.php?send2=1&amp;to_userid=".$thisUser->getVar('uid')."', 'pmlite', 450, 380);\"><img src=\"".XOOPS_URL."/images/icons/pm.gif\" alt=\"".sprintf(_SENDPMTO,$thisUser->getVar('uname'))."\" /></a>");
} else {
	$xoopsTpl->assign('user_pmlink', '');
}
$userrank =& $thisUser->rank();
if ($userrank['image']) {
	$xoopsTpl->assign('user_rankimage', '<img src="'.XOOPS_UPLOAD_URL.'/'.$userrank['image'].'" alt="" />');
}
$xoopsTpl->assign('user_ranktitle', $userrank['title']);
$date = $thisUser->getVar("last_login");
if (!empty($date)) {
	$xoopsTpl->assign('user_lastlogin', formatTimestamp($date,"m"));
}

$xoopsTpl->assign_by_ref("thisUser",$thisUser);

require_once XOOPS_ROOT_PATH.'/footer.php';
?>