<?php
// $Id: XCube_Utils.class.php,v 1.1.2.2 2005/11/15 12:42:56 minahito Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                  Copyright (c) 2000 XOOPSCube.org                         //
//                     <http://www.xoopscube.org/>                           //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //

class XCube_Utils
{
	/**
	Display redirect message and execute redirect.
	You can not continue your routine, because this method call exit().
	
	@todo I must solve direct HTML code.
	@param $url string
	@param $time intval
	@param $message If you want to multiline message, you must set message as array.
	*/
	function redirectHeader($url,$time,$messages=_TAKINGBACK)
	{
		global $xoopsConfig, $xoopsRequestUri;

		if (preg_match("/(javascript|vbscript):/si", $url) )
			$url = XOOPS_URL;


		$displayMessage = is_array($messages) ? implode("<br/>",$messages) : $messages;

		if (!defined('XOOPS_CPFUNC_LOADED')) {
			require_once XOOPS_ROOT_PATH.'/class/template.php';
			$xoopsTpl = new XoopsTpl();
			$xoopsTpl->assign('sitename', htmlspecialchars($xoopsConfig['sitename'], ENT_QUOTES));
			$xoopsTpl->assign('langcode', _LANGCODE);
			$xoopsTpl->assign('charset', _CHARSET);
			$xoopsTpl->assign('time', $time);

			if (defined('SID') && (! isset($_COOKIE[session_name()]) || ($xoopsConfig['use_mysession'] && $xoopsConfig['session_name'] != '' && !isset($_COOKIE[$xoopsConfig['session_name']])))) {
				if (!strstr($url, '?')) {
					$url .= '?' . SID;
				}
				else {
					$url .= '&amp;'.SID;
				}
			}

			$url = preg_replace("/&amp;/i", '&', htmlspecialchars($url, ENT_QUOTES));
			$xoopsTpl->assign('url', $url);
			$xoopsTpl->assign('message', $displayMessage);
			$xoopsTpl->assign('lang_ifnotreload', sprintf(_IFNOTRELOAD, $url));
			$GLOBALS['xoopsModuleUpdate'] = 1;
			$xoopsTpl->display('db:system_redirect.html');
		} else {
			$url = preg_replace("/&amp;/i", '&', htmlspecialchars($url, ENT_QUOTES));
			echo '
			<html>
			<head>
			<title>'.htmlspecialchars($xoopsConfig['sitename']).'</title>
			<meta http-equiv="Content-Type" content="text/html; charset='._CHARSET.'" />
			<meta http-equiv="Refresh" content="'.$time.'; url='.$url.'" />
			<style type="text/css">
					body {background-color : #fcfcfc; font-size: 12px; font-family: Trebuchet MS,Verdana, Arial, Helvetica, sans-serif; margin: 0px;}
					.redirect {width: 70%; margin: 110px; text-align: center; padding: 15px; border: #e0e0e0 1px solid; color: #666666; background-color: #f6f6f6;}
					.redirect a:link {color: #666666; text-decoration: none; font-weight: bold;}
					.redirect a:visited {color: #666666; text-decoration: none; font-weight: bold;}
					.redirect a:hover {color: #999999; text-decoration: underline; font-weight: bold;}
			</style>
			</head>
			<body>
			<div align="center">
			<div class="redirect">
			<span style="font-size: 16px; font-weight: bold;">'.$displayMessage.'</span>
			<hr style="height: 3px; border: 3px #E18A00 solid; width: 95%;" />
			<p>'.sprintf(_IFNOTRELOAD, $url).'</p>
			</div>
			</div>
			</body>
			</html>';
		}
		
		exit();
	}
	
	function formatMessage()
	{
		$arr=func_get_args();
		
		if(count($arr)==0)
			return null;

		$message = $arr[0];
		for($i=1;$i<count($arr);$i++) {
			$message=str_replace("{".($i-1)."}",$arr[$i],$message);
		}

		return $message;
	}
	
	function formatMessageByMap($subject,$arr)
	{
		$searches=array();
		$replaces=array();
		foreach($arr as $key=>$value) {
			$searches[]="{".$key."}";
			$replaces[]=$value;
		}

		return str_replace($searches,$replaces,$subject);
	}
}

?>