<?php

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * Type:     function
 * Name:     xoops_input
 * Version:  1.0
 * Date:     Nov 2, 2005
 * Author:   minahito
 * Purpose:  input tag with sanitize.
 * Input:    name = name of form 'name'
 *           type = "text" or other
 *           value = preset value
 *           class = html class
 *           size =
 *           maxlength =
 *           default ~ 
 * 
 * Examples: {xoops_input name=text value=$message}
 *           {xoops_input name=checkbox value=1 default=$value }
 * -------------------------------------------------------------
 */
function smarty_function_xoops_input($params, &$smarty)
{
	if(isset($params['name'])) {
		$name = trim($params['name']);
		$type = isset($params['type']) ? strtolower(trim($params['type'])) : "text";
		$class = isset($params['class']) ? trim($params['class']) : null;
		$size = isset($params['size']) ? intval($params['size']) : null;
		$maxlength = isset($params['maxlength']) ? intval($params['maxlength']) : null;
		$value = isset($params['value']) ? htmlspecialchars($params['value'],ENT_QUOTES) : null;
		$id = isset($params['id']) ? trim($params['id']) : null;
		$default = isset($params['default']) ? trim($params['default']) : null;

		$string="<input name=\"$name\"";
		if($class)
			$string.=" class=\"$class\"";
		if($type)
			$string.=" type=\"$type\"";
		if($size)
			$string.=" size=\"$size\"";
		if($maxlength)
			$string.=" maxlength=\"$maxlength\"";
		if($value!==null)
			$string.=" value=\"$value\"";
		if($id)
			$string.=" id=\"$id\"";

		if (isset($params['default'])) {
			$default = trim($params['default']);
			if ($value==$default) {
				if ($type = "checkbox" || $type == "radio") {
					$string .= " checked";
				}
			}
		}

		$string.=" />";

		print $string;
	}
}

?>
