<?php

require_once XOOPS_BASE_PATH."/admin/class/AbstractModuleInstaller.class.php";

/**
 * This class extends a base class for the process of install module. This is added
 * some private functions.
 */
class Legacy_ModuleInstaller extends Legacy_AbstractModuleInstaller
{
	var $mAgree = false;

	/**
	 * Load xoops module object that isn't installed and return it.
	 * @static
	 * @access public
	 * @param $dirname string
	 * @return XoopsModule
	 */
	function &loadModuleObject($dirname)
	{
		$ret = null;

		$moduleHandler =& xoops_gethandler('module');
		$module =& $moduleHandler->getByDirname($dirname);

		if (is_object($module))
			return $ret;

		$module =& $moduleHandler->create();
		$module->setVar('weight', 1);
		$module->loadInfoAsVar($this->mDirname);
		
		if ($module->get('dirname') == null) {
			return $ret;
		}
		
		if (isset($module->modinfo['installer']) && isset($module->modinfo['installer']['licence']) ) {
			$this->mAgree = true;
		}
		
		return $module;
	}
	
	function _installModule()
	{
		if (parent::_installModule()) {
			$gpermHandler =& xoops_gethandler('groupperm');

			//
			// Add a permission which administrators can manage.
			//
			$adminPerm =& $this->_createPermission();
			$adminPerm->setVar('gperm_name', 'module_admin');

			if (!$gpermHandler->insert($adminPerm)) {
				$log->addError("Could not set admin permission " . $this->mModule->getVar('mid'));
			}

			//
			// Add a permission which administrators can read.
			//
			$readPerm =& $this->_createPermission();
			$readPerm->setVar('gperm_name', 'module_read');

			if (!$gpermHandler->insert($readPerm)) {
				$log->addError("Could not set read permission " . $this->mModule->getVar('mid'));
			}
		}
	}

	/**
	 * Create a permission object which has been initialized for admin.
	 * For flexibility, creation only and not save it.
	 * @access private
	 */
	function &_createPermission()
	{
		$gpermHandler =& xoops_gethandler('groupperm');

		$perm =& $gpermHandler->create();

		$perm->setVar('gperm_groupid', XOOPS_GROUP_ADMIN);
		$perm->setVar('gperm_itemid', $this->mModule->getVar('mid'));
		$perm->setVar('gperm_modid', 1);
		
		return $perm;
	}

	function _installTable()
	{
		Legacy_ModuleUtils::installTable($this->mModule, $this->mLog);
	}

	function _installTemplate()
	{
		$templates = $this->mModule->getInfo('templates');
		if ($templates != false) {
			foreach ($templates as $template) {
				Legacy_ModuleUtils::installTemplate($this->mModule, $template, $this->mLog);
			}
		}
	}

	function _installBlock()
	{
		$definedBlocks = $this->mModule->getInfo('blocks');
		if($definedBlocks == false)
			return true;

		$blockHandler =& xoops_gethandler('block');

		$func_num=0;
		foreach ($definedBlocks as $block) {
			$func_num++;
			$newBlock =& Legacy_ModuleUtils::createBlockByInfo($this->mModule, $block);
			$newBlock->setVar('func_num', $func_num);

			Legacy_ModuleUtils::installBlock($this->mModule, $newBlock, $this->mLog);
		}
	}

	function _installPreference()
	{
		Legacy_ModuleUtils::insertAllConfigs($this->mModule, $this->mLog);
	}
	
	function _processScript()
	{
		$installScript = trim($this->mModule->getInfo('onInstall'));
		if ($installScript != false) {
			require_once XOOPS_MODULE_PATH . "/" . $this->mModule->getVar('dirname') . "/" . $installScript;
			$funcName = 'xoops_module_install_' . $this->mModule->getVar('dirname');
			if (function_exists($funcName)) {
				if (!call_user_func($funcName, $this->mModule)) {
					$this->mLog->addError("Failed to execute " . $funcName);
				}
			}
		}
	}

	function hasAgree()
	{
		return $this->mAgree;
	}
}

?>