<?php

require_once XOOPS_MODULE_PATH . "/legacyRender/admin/forms/TplsetDeleteForm.class.php";

class LegacyRender_TplsetDeleteAction extends LegacyRender_Action
{
	var $mObject = null;
	var $mObjectHandler = null;
	var $mActionForm=null;
	
	function getDefaultView(&$controller,&$xoopsUser)
	{
		$this->_setupActionForm();
		$this->_setupObject($controller);

		if ($this->mObject == null) {
			return LEGACYRENDER_FRAME_VIEW_ERROR;
		}

		$this->mActionForm->load($this->mObject);

		return LEGACYRENDER_FRAME_VIEW_INPUT;
	}
	
	function execute(&$controller,&$xoopsUser)
	{
		$this->_setupActionForm();
		$this->_setupObject($controller);

		if ($this->mObject == null) {
			return LEGACYRENDER_FRAME_VIEW_ERROR;
		}

		//
		// If image is no, the data has to continue to keep his value.
		//
		$this->mActionForm->load($this->mObject);

		$this->mActionForm->fetch();
		$this->mActionForm->validate();

		if($this->mActionForm->hasError())
			return LEGACYRENDER_FRAME_VIEW_INPUT;
			
		$this->mActionForm->update($this->mObject);

		return $this->mObjectHandler->delete($this->mObject) ? LEGACYRENDER_FRAME_VIEW_SUCCESS
		                                                       : LEGACYRENDER_FRAME_VIEW_ERROR;
	}

	function _setupObject(&$controller)
	{
		$id = $this->_getId();
		
		$this->mObjectHandler = $this->_getHandler();
		
		$this->mObject =& $this->mObjectHandler->get($id);
		if (is_object($this->mObject) && $this->mObject->get('tplset_name') == 'default') {
			$this->mObject = null;
		}
	}
	
	function &_getHandler()
	{
		$handler = xoops_getmodulehandler('tplset');
		return $handler;
	}
	
	function _getId()
	{
		return isset($_REQUEST['tplset_id']) ? intval($_REQUEST['tplset_id']) : 0;
	}
	
	function _setupActionForm()
	{
		$this->mActionForm =& new TplsetDeleteForm();
		$this->mActionForm->prepare();
	}

	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("tplset_delete.html");
		$render->setAttribute('actionForm', $this->mActionForm);
		$render->setAttribute('object', $this->mObject);
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		header("location: ./index.php?action=TplsetList");
		exit();
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		redirect_header("./index.php?action=TplsetList", 1, _AD_LEGACYRENDER_ERROR_DBUPDATE_FAILED);
	}
}

?>