<?php

require_once XOOPS_MODULE_PATH . "/legacyRender/admin/forms/TplsetEditForm.class.php";

/**
 * This class is generated by makeActionForm tool.
 */
class TplsetCloneForm extends TplsetEditForm
{
	function getTokenName()
	{
		return "module.legacyRender.TplsetCloneForm.TOKEN";
	}

	function prepare()
	{
		parent::prepare();
		//
		// Set form properties
		//
		$this->mFormProperties['tplset_id'] =& new XCube_IntProperty('tplset_id');
		$this->mFormProperties['tplset_name'] =& new XCube_StringProperty('tplset_name');
		$this->mFormProperties['tplset_credits'] =& new XCube_TextProperty('tplset_credits');

		//
		// Set field properties
		//
		$this->mFieldProperties['tplset_name'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['tplset_name']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['tplset_name']->addMessage('required', _AD_LEGACYRENDER_ERROR_REQUIRED, _AD_LEGACYRENDER_LANG_TPLSET_NAME, '50');
		$this->mFieldProperties['tplset_name']->addMessage('maxlength', _AD_LEGACYRENDER_ERROR_MAXLENGTH, _AD_LEGACYRENDER_LANG_TPLSET_NAME, '50');
		$this->mFieldProperties['tplset_name']->addVar('maxlength', 50);
	}
	
	function validateTplset_name()
	{
		//
		// Check unique name
		//
		$handler = xoops_getmodulehandler('tplset');

		if ($this->get('tplset_name') != null) {
			if ($handler->getCount(new Criteria('tplset_name', $this->get('tplset_name'))) > 0) {
				$this->addErrorMessage(_AD_LEGACYRENDER_ERROR_UNIQUE_NAME);
			}
			if (!preg_match("/^[a-z0-9\_]+$/i", $this->get('tplset_name'))) {
				$this->addErrorMessage(_AD_LEGACYRENDER_ERROR_TPLSET_NAME_RULE);
			}
		}
		
	}

	function load(&$obj)
	{
		parent::load($obj);
		$this->setVar('tplset_name', $obj->get('tplset_name'));
	}

	function update(&$obj)
	{
		parent::update($obj);
		$obj->setVar('tplset_name', $this->get('tplset_name'));
		$obj->setVar('tplset_id', 0);
	}
}

?>
