<?php

require_once XOOPS_MODULE_PATH . "/user/class/AbstractEditAction.class.php";
require_once XOOPS_MODULE_PATH . "/user/forms/AvatarEditForm.class.php";
require_once XOOPS_MODULE_PATH . "/user/forms/AvatarSelectForm.class.php";
require_once XOOPS_MODULE_PATH . "/user/forms/AvatarFilterForm.class.php";
require_once XOOPS_MODULE_PATH . "/user/class/PageNavigator.class.php";

/**
 *  When the request is GET, shows two forms to changing a avatar for specified
 * user. One of form shows upload-form. Other form shows the list of preset
 * avatar (system avatar) and its page navigator. 
 */
class User_AvatarEditAction extends User_AbstractEditAction
{
	var $mAvatarWidth = 0;
	var $mAvatarHeight = 0;
	var $mAvatarMaxfilesize = 0;
	
	var $_mMinPost = 0;
	var $_mAllowUpload = false;
	
	var $mNavi;
	var $mFilter;

	/**
	 * Preset avatar object collection.
	 */	
	var $mSystemAvatars = array();
	
	/**
	 * Other action form for AvatarSelect.
	 */
	var $mAvatarSelectForm = null;
	
	/**
	 *  Set up own properties by $moduleConfig. We must know uploading conditions
	 * and control user upload by it. The limit may be not completed, yet.
	 */
	function prepare(&$controller, &$xoopsUser, &$moduleConfig)
	{
		$this->mAvatarWidth = $moduleConfig['avatar_width'];
		$this->mAvatarHeight = $moduleConfig['avatar_height'];
		$this->mAvatarMaxfilesize = $moduleConfig['avatar_maxsize'];
		
		$this->_mMinPost = $moduleConfig['avatar_minposts'];
		$this->_mAllowUpload = $moduleConfig['avatar_allow_upload'];

		parent::prepare($controller, $xoopsUser, $moduleConfig);
	}

	function _getId()
	{
		return isset($_REQUEST['uid']) ? intval($_REQUEST['uid']) : 0;
	}
	
	function &_getHandler()
	{
		$handler =& xoops_gethandler('user');
		return $handler;
	}

	/**
	 *  This class uses AvatarUploadForm class. It requests three condition which
	 * are width limit, height limit and filesize limit. We send own properties to 
	 * AvatarUploadForm::prepare()
	 */
	function _setupActionForm()
	{
		$this->mActionForm=new User_AvatarEditForm();
		$this->mActionForm->prepare($this->mAvatarWidth, $this->mAvatarHeight, $this->mAvatarMaxfilesize);
	}
	
	/**
	 *  Return false.
	 *  If a user requests dummy uid, kick out him!
	 */
	function isEnableCreate()
	{
		return false;
	}

	/**
	 *  Return true.
	 *  This action should not be used by a guest user.
	 */
	function isSecure()
	{
		return true;
	}
	
	/**
	 *  Check whether a current user can access this action.
	 * 1) A specified user has to exist.
	 * 2) A current user has to equal the specified user, or a current user has
	 *    to be a administrator.
	 */
	function isPerm(&$controller, &$xoopsUser)
	{
		if (!is_object($this->mObject)) {
			return false;
		}

		if ($this->mObject->isAdmin()) {
			return true;
		}
		elseif ($this->mObject->get('uid') == $xoopsUser->get('uid')) {
			return ($this->mObject->get('posts') >= $this->_mMinPost);
		}
		
		return false;
	}

	/**
	 *  This override method looks like the same method of ListAction, and tries
	 * to get system avatars. After, it will call base class.
	 */
	function getDefaultView(&$controller, &$xoopsUser)
	{
		$this->mNavi =& new User_PageNavigator("index.php?AvatarUpload", 0, XCUBE_PAGENAVI_START);
		
		$this->mFilter =& new User_AvatarFilterForm($this->mNavi);
		$this->mFilter->fetch();
		$handler =& xoops_gethandler('avatar');
		
		$total = $handler->getCount($this->mFilter->getCriteria());
		
		$this->mNavi->setTotal($total);
		$this->mNavi->fetch();
		
		$criteria = $this->mFilter->getCriteria($this->mNavi->getStart(), $this->mNavi->getPerpage());
		$this->mSystemAvatars =& $handler->getObjects($criteria);
		
		$this->mAvatarSelectForm =& new User_AvatarSelectForm();
		$this->mAvatarSelectForm->prepare();
		
		$this->mAvatarSelectForm->load($this->mObject);
		
		return parent::getDefaultView($controller, $xoopsUser);
	}
	
	/**
	 * 1) Save avatar file which has been uploaded.
	 * 2) If old avatar file exists, remove it.
	 * 3) Insert a data to DB with calling base class method.
	 */
	function _doExecute()
	{
		if ($this->mActionForm->mFormFile != null) {
			if (!$this->mActionForm->mFormFile->saveAs(XOOPS_UPLOAD_PATH)) {
				return false;
			}
		}
		
		if ($this->mActionForm->mOldAvatarFilename != null && $this->mActionForm->mOldAvatarFilename != "blank.gif") {
				@unlink(XOOPS_UPLOAD_PATH . "/" . $this->mActionForm->mOldAvatarFilename);
		}
		
		return parent::_doExecute();
	}

	function executeViewInput(&$controller,&$xoopsUser,&$render)
	{
		$render->setTemplateName("user_avatar_edit.html");
		$render->setAttribute("actionForm",$this->mActionForm);
		$render->setAttribute("thisUser",$this->mObject);

		$render->setAttribute("allowUpload", $this->_mAllowUpload);
		$render->setAttribute("avatarWidth",$this->mAvatarWidth);
		$render->setAttribute("avatarHeight",$this->mAvatarHeight);
		$render->setAttribute("avatarMaxfilesize",$this->mAvatarMaxfilesize);

		$render->setAttribute("pageNavi", $this->mNavi);
		$render->setAttribute("systemAvatars", $this->mSystemAvatars);
		$render->setAttribute("avatarSelectForm", $this->mAvatarSelectForm);
	}
	
	function executeViewSuccess(&$controller,&$xoopsUser,&$renderSystem)
	{
		$controller->executeForward("./index.php?action=UserInfo&uid=" . $this->mActionForm->get('uid'));
	}

	function executeViewError(&$controller,&$xoopsUser,&$renderSystem)
	{
		redirect_header("./index.php?action=UserInfo&uid=" . $this->mActionForm->get('uid'), 1, _MD_ERROR_DBUPDATE_FAILED);
	}
}

?>