<?php

require_once XOOPS_MODULE_PATH . "/user/class/AbstractEditAction.class.php";
require_once XOOPS_MODULE_PATH . "/user/forms/AvatarSelectForm.class.php";

/**
 *  When the request is POST, this class fetches avatar_id and set it to user
 * object. This class always kicks out GET request.
 */
class User_AvatarSelectAction extends User_AbstractEditAction
{
	function _getId()
	{
		return isset($_REQUEST['uid']) ? intval($_REQUEST['uid']) : 0;
	}
	
	function &_getHandler()
	{
		$handler =& xoops_gethandler('user');
		return $handler;
	}

	function _setupActionForm()
	{
		$this->mActionForm =& new User_AvatarSelectForm();
		$this->mActionForm->prepare();
	}
	
	/**
	 *  Return false.
	 *  If a user requests dummy uid, kick out him!
	 */
	function isEnableCreate()
	{
		return false;
	}

	/**
	 *  Return true.
	 *  This action should not be used by a guest user.
	 */
	function isSecure()
	{
		return true;
	}
	
	/**
	 *  Check whether a current user can access this action.
	 * 1) A specified user has to exist.
	 * 2) A current user has to equal the specified user, or a current user has
	 *    to be a administrator.
	 */
	function isPerm(&$controller, &$xoopsUser)
	{
		if (!is_object($this->mObject)) {
			return false;
		}

		if ($this->mObject->isAdmin()) {
			return true;
		}
		elseif ($this->mObject->get('uid') == $xoopsUser->get('uid')) {
			return ($this->mObject->get('posts') >= $this->_mMinPost);
		}
		
		return false;
	}

	/**
	 * This action always kicks out GET request.
	 */
	function getDefaultView(&$controller, &$xoopsUser)
	{
		$controller->executeForward("./index.php?action=AvatarUpload&uid=" . $this->mObject->get('uid'));
		return USER_FRAME_VIEW_NONE;
	}
	
	function executeViewSuccess(&$controller,&$xoopsUser,&$renderSystem)
	{
		$controller->executeForward("./index.php?action=UserInfo&uid=" . $this->mActionForm->get('uid'));
	}

	function executeViewError(&$controller,&$xoopsUser,&$renderSystem)
	{
		redirect_header("./index.php?action=UserInfo&uid=" . $this->mActionForm->get('uid'), 1, _MD_ERROR_DBUPDATE_FAILED);
	}
}

?>