<?php

require_once XOOPS_MODULE_PATH . "/user/forms/LostpassEditForm.class.php";
require_once XOOPS_MODULE_PATH . "/user/class/LostpassMailBuilder.class.php";
require_once XOOPS_MODULE_PATH . "/user/class/LostpassMailDirector.class.php";

class User_LostpassAction extends User_Action
{
	var $mActionForm = null;
	
	function prepare(&$controller, &$xoopsUser)
	{
		$this->mActionForm =& new LostpassEditForm();
		$this->mActionForm->prepare();
	}
	
	function isSecure()
	{
		return false;
	}
	
	function isPerm(&$controller, &$xoopsUser)
	{
		return !is_object($xoopsUser);
	}

	function getDefaultView(&$controller, &$xoopsUser)
	{
		return USER_FRAME_VIEW_INPUT;
	}
	
	function execute(&$controller, &$xoopsUser)
	{
		$this->mActionForm->fetch();
		$this->mActionForm->validate();
		
		if ($this->mActionForm->hasError()) {
			return USER_FRAME_VIEW_INPUT;
		}
		
		$userHandler =& xoops_gethandler('user');
		$lostUserArr =& $userHandler->getObjects(new Criteria('email', $this->mActionForm->get('email')));

		if (is_array($lostUserArr) && count($lostUserArr) > 0) {
			$lostUser =& $lostUserArr[0];
		}
		else {
			return USER_FRAME_VIEW_SUCCESS;
		}

		$builder =& new LostpassMailBuilder();
		$director =& new LostpassMailDirector($builder, $lostUser, $controller->mConfig);
		$director->contruct();
		$xoopsMailer =& $builder->getResult();

		if (!$xoopsMailer->send()) {
			// $xoopsMailer->getErrors();
			return USER_FRAME_VIEW_ERROR;
		}

		return USER_FRAME_VIEW_SUCCESS;
	}
	
	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("user_lostpass.html");
		$render->setAttribute("actionForm", $this->mActionForm);
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		//
		//
		//
		die("TODO");
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		redirect_header(XOOPS_URL, 3, _MD_ERROR_SEND_MAIL);
	}
}

?>