<?php

require_once XOOPS_MODULE_PATH . "/user/class/AbstractFilterForm.class.php";

define('GROUP_SORT_KEY_DEFAULT', 0);
define('GROUP_SORT_KEY_GROUPID', 1);
define('GROUP_SORT_KEY_NAME', 2);
define('GROUP_SORT_KEY_DESCRIPTION', 3);
define('GROUP_SORT_KEY_GROUP_TYPE', 4);
define('GROUP_SORT_KEY_MAXVALUE', 4);

class User_GroupFilterForm extends User_AbstractFilterForm
{
	var $mSort = 0;
	var $_mSortKeys = array(
		GROUP_SORT_KEY_DEFAULT => 'groupid',
		GROUP_SORT_KEY_GROUPID => 'groupid',
		GROUP_SORT_KEY_NAME => 'name',
		GROUP_SORT_KEY_DESCRIPTION => 'description',
		GROUP_SORT_KEY_GROUP_TYPE => 'group_type'
	);
	var $_mCriteria = null;

	function fetch()
	{
		$this->mSort = isset($_REQUEST['sort']) ? intval($_REQUEST['sort']) : 0;
	
		if ($this->mSort > GROUP_SORT_KEY_MAXVALUE) {
			$this->mSort = GROUP_SORT_KEY_DEFAULT;
		}
	
		if (isset($_REQUEST['groupid'])) {
			$this->_mCriteria->add(new Criteria('groupid', array(XOBJ_DTYPE_INT, xoops_getrequest('groupid'))));
		}
	
		if (isset($_REQUEST['name'])) {
			$this->_mCriteria->add(new Criteria('name', array(XOBJ_DTYPE_STRING, xoops_getrequest('name'))));
		}
	
		if (isset($_REQUEST['group_type'])) {
			$this->_mCriteria->add(new Criteria('group_type', array(XOBJ_DTYPE_STRING, xoops_getrequest('group_type'))));
		}
	}
}

?>
