<?php

define("RANK_SORT_KEY_DEFAULT",  0);
define("RANK_SORT_KEY_ID",       1);
define("RANK_SORT_KEY_TITLE",    2);
define("RANK_SORT_KEY_MIN",      3);
define("RANK_SORT_KEY_MAX",      4);
define("RANK_SORT_KEY_SPECIAL",  5);
define("RANK_SORT_KEY_IMAGE",    6);

define("RANK_SORT_KEY_MAXVALUE", 6);

/**
 *
 */
class RankActionFilterForm
{
	var $mSpecial=null;

	var $mSortKey=0;

	var $_mSortKeys=array(
		RANK_SORT_KEY_DEFAULT    => "rank_id",
		RANK_SORT_KEY_ID         => "rank_id",
		RANK_SORT_KEY_TITLE      => "rank_title",
		RANK_SORT_KEY_MIN        => "rank_min",
		RANK_SORT_KEY_MAX        => "rank_max",
		RANK_SORT_KEY_SPECIAL    => "rank_special",
		RANK_SORT_KEY_IMAGE      => "rank_image"
	);

	function fetch()
	{
		$this->mSpecial=isset($_REQUEST['special']) ? intval($_REQUEST['special']) : null;

		$this->mSortKey=isset($_REQUEST['sort']) ? intval($_REQUEST['sort']) : 0;

		if($this->mSortKey>RANK_SORT_KEY_MAXVALUE)
			$this->mSortKey=0;
	}

	function getSort()
	{
		$sortkey=abs($this->mSortKey);
		return $this->_mSortKeys[$sortkey];
	}
	
	function getOrder()
	{
		return ($this->mSortKey < 0) ? "DESC" : "ASC";
	}
}

?>