<?php

class UserUsersObject extends XoopsSimpleObject
{
	var $Groups = array();
	
	function UserUsersObject()
	{
		$this->initVar('uid', XOBJ_DTYPE_INT, 0, true);
		$this->initVar('name', XOBJ_DTYPE_STRING, '', false, 60);
		$this->initVar('uname', XOBJ_DTYPE_STRING, '', true, 25);
		$this->initVar('email', XOBJ_DTYPE_STRING, '', true, 60);
		$this->initVar('url', XOBJ_DTYPE_STRING, '', false, 100);
		$this->initVar('user_avatar', XOBJ_DTYPE_STRING, 'blank.gif', false, 30);
		$this->initVar('user_regdate', XOBJ_DTYPE_INT, time(), true);
		$this->initVar('user_icq', XOBJ_DTYPE_STRING, '', false, 15);
		$this->initVar('user_from', XOBJ_DTYPE_STRING, '', false, 100);
		$this->initVar('user_sig', XOBJ_DTYPE_TEXT, '', false);
		$this->initVar('user_viewemail', XOBJ_DTYPE_BOOL, '0', false);
		$this->initVar('actkey', XOBJ_DTYPE_STRING, '', false, 8);
		$this->initVar('user_aim', XOBJ_DTYPE_STRING, '', false, 18);
		$this->initVar('user_yim', XOBJ_DTYPE_STRING, '', false, 25);
		$this->initVar('user_msnm', XOBJ_DTYPE_STRING, '', false, 100);
		$this->initVar('pass', XOBJ_DTYPE_STRING, '', false, 32);
		$this->initVar('posts', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('attachsig', XOBJ_DTYPE_BOOL, '0', false);
		$this->initVar('rank', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('level', XOBJ_DTYPE_INT, '1', false);
		$this->initVar('theme', XOBJ_DTYPE_STRING, '', false, 100);
		$this->initVar('timezone_offset', XOBJ_DTYPE_FLOAT, '0.0', false);
		$this->initVar('last_login', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('umode', XOBJ_DTYPE_STRING, '', false, 10);
		$this->initVar('uorder', XOBJ_DTYPE_BOOL, '0', false);
		$this->initVar('notify_method', XOBJ_DTYPE_BOOL, '1', false);
		$this->initVar('notify_mode', XOBJ_DTYPE_BOOL, '0', false);
		$this->initVar('user_occ', XOBJ_DTYPE_STRING, '', false, 100);
		$this->initVar('bio', XOBJ_DTYPE_TEXT, '', false);
		$this->initVar('user_intrest', XOBJ_DTYPE_STRING, '', false, 150);
		$this->initVar('user_mailok', XOBJ_DTYPE_BOOL, '1', false);
	}
	
	function getGroups()
	{
		return $this->Groups;
	}
}

class UserUsersHandler extends XoopsObjectGenericHandler
{
	var $mTable = "users";
	var $mPrimary = "uid";
	var $mClass = "UserUsersObject";
	
	function &get($id)
	{
		$obj =& parent::get($id);
		
		if (is_object($obj)) {
			$this->_loadGroups($obj);
		}
		
		return $obj;
	}
	
	function &getObjects($criteria = null, $param1 = false, $param2 = false, $param3 = false)
	{
		$objects =& parent::getObjects($criteria, $param1, $param2, $param3);

		if (count($objects)) {
			foreach (array_keys($objects) as $key) {
				$this->_loadGroups($objects[$key]);
			}
		}
	}
	
	function insert(&$user, $force = false)
	{
		if (parent::insert($user, $force)) {
			$flag = true;

			$handler =& xoops_getmodulehandler('groups_users_link');
			$handler->deleteAll(new Criteria('uid', $user->get('uid')), $force);

			foreach ($user->Groups as $gid) {
				$link =& $handler->create();
				
				$link->set('groupid', $gid);
				$link->set('uid', $user->get('uid'));
				
				$flag &= $handler->insert($link, $force);
				
				unset($link);
			}
			
			return $flag;
		}
		
		return false;
	}
	
	function _loadGroups(&$user)
	{
		$handler =& xoops_getmodulehandler('groups_users_link');
		$links =& $handler->getObjects(new Criteria('uid', $user->get('uid')));
		foreach ($links as $link) {
			$user->Groups[] = $link->get('groupid');
		}
	}
}

?>
