<?php

/**
 * This class is generated by makeActionForm tool.
 * @auchor makeActionForm
 */
class RegisterUserEditForm extends XCube_ActionForm 
{
	var $mConfig;

	function getTokenName()
	{
		return "module.user.RegisterUserEditForm.TOKEN";
	}

	function RegisterUserEditForm()
	{
	}
	
	function prepare($userConfig)
	{
		$this->mConfig=$userConfig;
		
		// set properties
		$this->mFormProperties['uname']=new XCube_StringProperty('uname');
		$this->mFormProperties['email']=new XCube_StringProperty('email');
		$this->mFormProperties['user_viewemail']=new XCube_IntProperty('user_viewemail');
		$this->mFormProperties['url']=new XCube_StringProperty('url');
		$this->mFormProperties['pass']=new XCube_StringProperty('pass');
		$this->mFormProperties['vpass']=new XCube_StringProperty('vpass');
		$this->mFormProperties['user_mailok']=new XCube_IntProperty('user_mailok');

		// set fields
		$this->mFieldProperties['uname']=new XCube_FieldProperty($this);
		$this->mFieldProperties['uname']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['uname']->addMessage("required",_MD_USER_ERROR_REQUIRED,_US_NICKNAME,"25");
		$this->mFieldProperties['uname']->addMessage("minlength",_MD_USER_ERROR_MINLENGTH,_US_NICKNAME,"25");
		$this->mFieldProperties['uname']->addMessage("maxlength",_MD_USER_ERROR_MAXLENGTH,_US_NICKNAME,"25");
		$this->mFieldProperties['uname']->addVar("minlength",$userConfig['minuname']);
		$this->mFieldProperties['uname']->addVar("maxlength",$userConfig['maxuname']);

		$this->mFieldProperties['email']=new XCube_FieldProperty($this);
		$this->mFieldProperties['email']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['email']->addMessage("required",_MD_USER_ERROR_REQUIRED,_US_EMAIL,"60");
		$this->mFieldProperties['email']->addMessage("maxlength",_MD_USER_ERROR_MAXLENGTH,_US_EMAIL,"60");
		$this->mFieldProperties['email']->addVar("maxlength",60);

		$this->mFieldProperties['user_viewemail']=new XCube_FieldProperty($this);
		$this->mFieldProperties['user_viewemail']->setDependsByArray(array('intRange'));
		$this->mFieldProperties['user_viewemail']->addMessage("intRange",_MD_USER_ERROR_INTRANGE,"user_viewemail");
		$this->mFieldProperties['user_viewemail']->addVar("min",0);
		$this->mFieldProperties['user_viewemail']->addVar("max",1);

		$this->mFieldProperties['url']=new XCube_FieldProperty($this);
		$this->mFieldProperties['url']->setDependsByArray(array('maxlength'));
		$this->mFieldProperties['url']->addMessage("maxlength",_MD_USER_ERROR_MAXLENGTH,_US_WEBSITE,"100");
		$this->mFieldProperties['url']->addVar("maxlength",100);

		$this->mFieldProperties['user_mailok']=new XCube_FieldProperty($this);
		$this->mFieldProperties['user_mailok']->setDependsByArray(array('intRange'));
		$this->mFieldProperties['user_mailok']->addMessage("intRange",_MD_USER_ERROR_INTRANGE,"user_mailok");
		$this->mFieldProperties['user_mailok']->addVar("min",0);
		$this->mFieldProperties['user_mailok']->addVar("max",1);

		$this->mFieldProperties['pass']=new XCube_FieldProperty($this);
		$this->mFieldProperties['pass']->setDependsByArray(array('required','minlength','maxlength'));
		$this->mFieldProperties['pass']->addMessage("required",_MD_USER_ERROR_REQUIRED,_US_PASSWORD,"30","60");
		$this->mFieldProperties['pass']->addMessage("minlength",_MD_USER_ERROR_PASSWORD_MINLENGTH,_US_PASSWORD,"30","60");
		$this->mFieldProperties['pass']->addMessage("maxlength",_MD_USER_ERROR_PASSWORD_MAXLENGTH,_US_PASSWORD,"30","60");
		$this->mFieldProperties['pass']->addVar("minlength",$userConfig['minpass']);
		$this->mFieldProperties['pass']->addVar("maxlength",32);
	}

	function validatePass()
	{
		if(strlen($this->getVar('pass'))>0||strlen($this->getVar('vpass'))>0)
			if($this->getVar('pass')!=$this->getVar('vpass')) {
				$this->addErrorMessage(_MD_USER_ERROR_PASSWORD);
				$this->set('pass',null);	// reset
				$this->set('vpass',null);
			}
	}

	function validateUname()
	{
		if($this->getVar('uname')) {

			//
			// uname unique check
			//
			$userHandler=&xoops_gethandler('user');
			$count=$userHandler->getCount(new Criteria('uname',$this->getVar('uname')));
			if($count!=0) {
				$this->addErrorMessage(_US_NICKNAMETAKEN);
			}

			//
			// Check allow uname string pattern.
			//
			$regex="";
			switch($this->mConfig['uname_test_level']) {
				case 0:
					$regex="/[^a-zA-Z0-9\_\-]/";
					break;

				case 1:
					$regex="/[^a-zA-Z0-9\_\-\<\>\,\.\$\%\#\@\!\\\'\"]/";
					break;

				case 2:
					$regex="//[\000-\040]/";
					break;
			}
			if(preg_match($regex,$this->getVar('uname'))) {
				$this->addErrorMessage(_US_INVALIDNICKNAME);
			}


			//
			// Check bad uname patterns.
			//
			foreach(explode("|",$this->mConfig['bad_unames']) as $pattern) {
				if(!empty($pattern)&&preg_match("/".$pattern."/i",$this->getVar('uname'))) {
					$this->addErrorMessage(_US_NAMERESERVED);
					break;
				}
			}
		}
	}

	function validateEmail()
	{
		if($this->getVar('email')) {

			//
			// email unique check
			//
			$userHandler=&xoops_gethandler('user');
			$count=$userHandler->getCount(new Criteria('email',$this->getVar('email')));
			if($count!=0) {
				$this->addErrorMessage(_US_EMAILTAKEN);
			}
			

			//
			// Check bad email patterns.
			//
			foreach(explode("|",$this->mConfig['bad_emails']) as $pattern) {
				if(!empty($pattern)&&preg_match("/".$pattern."/i",$this->getVar('email'))) {
					$this->addErrorMessage(_US_INVALIDMAIL);
					break;
				}
			}
		}
	}

	function update(&$user)
	{
		$user->set('uname',$this->getVar('uname'),true);
		$user->set('email',$this->getVar('email'),true);
		$user->set('user_viewemail',$this->getVar('user_viewemail'),true);
		$user->set('url',$this->getVar('url'),true);
		$user->set('user_avatar','blank.gif',true);
        $user->set('pass', md5($this->getVar('pass')), true);
        // $user->set('timezone_offset',$this->getVar('timezone_offset'),true);
        $user->set('user_mailok',$this->getVar('user_mailok'),true);

		$actkey=substr(md5(uniqid(mt_rand(),1)),0,8);
        $user->set('actkey',$actkey,true);
        $user->set('user_regdate',time(),true);
	}
}

class RegisterUserAgreeEditForm extends RegisterUserEditForm 
{
	function prepare($userConfig)
	{
		parent::prepare($userConfig);
		
		// set properties
		$this->mFormProperties['agree']=new XCube_IntProperty('agree');

		// set fields
		$this->mFieldProperties['agree']=new XCube_FieldProperty($this);
		$this->mFieldProperties['agree']->setDependsByArray(array('required','intRange'));
		$this->mFieldProperties['agree']->addMessage("required",_US_UNEEDAGREE);
		$this->mFieldProperties['agree']->addMessage("intRange",_US_UNEEDAGREE);
		$this->mFieldProperties['agree']->addVar("min",1);
		$this->mFieldProperties['agree']->addVar("max",1);
	}
}


?>
