<?php
/**
 * @version $Id: InstallWizardAction.class.php,v 1.1.2.2 2006/03/28 13:28:35 minahito Exp $
 */

 if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_BASE_PATH."/admin/actions/AbstractModuleInstallAction.class.php";
require_once XOOPS_BASE_PATH."/admin/class/ModuleInstaller.class.php";
require_once XOOPS_BASE_PATH."/admin/forms/InstallWizardForm.class.php";

/**
 * Install module
 */
class Legacy_InstallWizardAction extends Legacy_AbstractModuleInstallAction
{
	var $mLicence;
	var $mLicenceText;

	function &_getInstaller($dirname)
	{
		$installer =& new Legacy_ModuleInstaller($dirname);
		return $installer;
	}
	
	function _setupActionForm()
	{
		$this->mActionForm =& new Legacy_InstallWizardForm();
		$this->mActionForm->prepare();
	}

	function _loadAgreement()
	{
		$root =& XCube_Root::getSingleton();
		
		$this->mLicence = $this->mModuleObject->modinfo['installer']['licence']['title'];

		$file = $this->mModuleObject->modinfo['installer']['licence']['file'];
		$language = $root->mController->getConfig('language');

		$path = XOOPS_MODULE_PATH . "/" . $this->mModuleObject->getVar('dirname') ."/language/" . $language . "/" . $file;
		if (!file_exists($path)) {
			$path = XOOPS_MODULE_PATH . "/" . $this->mModuleObject->getVar('dirname') . "pm/language/english/" . $file;
			if (!file_exists($path)) {
				return;
			}
		}

		$this->mLicenceText = file_get_contents($path);
	}
	
	function executeViewSuccess(&$controller,&$xoopsUser,&$renderer)
	{
		$renderer->setTemplateName("module_install_success.html");
		$renderer->setAttribute('log', $this->mLog->mMessages);
	}

	function executeViewIndex(&$controller,&$xoopsUser,&$renderer)
	{
		$renderer->setAttribute('module', $this->mModuleObject);
		$renderer->setAttribute('actionForm', $this->mActionForm);

		if (isset($this->mModuleObject->modinfo['installer'])) {
			$renderer->setAttribute('image', $this->mModuleObject->modinfo['installer']['image']);
			$renderer->setAttribute('description', $this->mModuleObject->modinfo['installer']['description']);
			$renderer->setTemplateName("install_wizard.html");
		}
		else {
			$controller->executeForward("index.php?action=ModuleInstall&dirname=" . $this->mModuleObject->get('dirname'));
		}
	}

	function executeViewInput(&$controller, &$xoopsUser, &$renderer)
	{
		$renderer->setTemplateName("install_wizard_licence.html");
		$renderer->setAttribute('module', $this->mModuleObject);
		$renderer->setAttribute('actionForm', $this->mActionForm);
		$renderer->setAttribute('licence', $this->mLicence);
		$renderer->setAttribute('licenceText', $this->mLicenceText);
	}
}

?>