<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH . "/class/XCube_ActionForm.class.php";
require_once XOOPS_MODULE_PATH . "/base/class/Legacy_Validator.class.php";

class Legacy_BlockEditForm extends XCube_ActionForm
{
	function getTokenName()
	{
		return "module.base.BlockEditForm.TOKEN" . $this->get('bid');
	}

	function prepare()
	{
		//
		// Set form properties
		//
		$this->mFormProperties['bid'] =& new XCube_IntProperty('bid');
		$this->mFormProperties['options'] =& new XCube_StringArrayProperty('options');
		$this->mFormProperties['title'] =& new XCube_StringProperty('title');
		$this->mFormProperties['side'] =& new XCube_IntProperty('side');
		$this->mFormProperties['weight'] =& new XCube_IntProperty('weight');
		$this->mFormProperties['bcachetime'] =& new XCube_IntProperty('bcachetime');
		$this->mFormProperties['bmodule'] =& new XCube_IntArrayProperty('bmodule');
		$this->mFormProperties['groupid'] =& new XCube_IntArrayProperty('groupid');
	
		//
		// Set field properties
		//
	
		$this->mFieldProperties['bid'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['bid']->setDependsByArray(array('required'));
		$this->mFieldProperties['bid']->addMessage('required', _AD_BASE_ERROR_REQUIRED, _AD_BASE_LANG_BID);
	
		$this->mFieldProperties['title'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['title']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['title']->addMessage('required', _AD_BASE_ERROR_REQUIRED, _AD_BASE_LANG_TITLE, '255');
		$this->mFieldProperties['title']->addMessage('maxlength', _AD_BASE_ERROR_MAXLENGTH, _AD_BASE_LANG_TITLE, '255');
		$this->mFieldProperties['title']->addVar('maxlength', '255');
	
		$this->mFieldProperties['side'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['side']->setDependsByArray(array('required'));
		$this->mFieldProperties['side']->addMessage('required', _AD_BASE_ERROR_REQUIRED, _AD_BASE_LANG_SIDE);
	
		$this->mFieldProperties['weight'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['weight']->setDependsByArray(array('required'));
		$this->mFieldProperties['weight']->addMessage('required', _AD_BASE_ERROR_REQUIRED, _AD_BASE_LANG_WEIGHT);
	
		$this->mFieldProperties['bcachetime'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['bcachetime']->setDependsByArray(array('required'));
		$this->mFieldProperties['bcachetime']->addMessage('required', _AD_BASE_ERROR_REQUIRED, _AD_BASE_LANG_BCACHETIME);
	}

	function validateBmodule()
	{
		$bmodule = $this->get('bmodule');
		if (!(count($bmodule))) {
			$this->addErrorMessage(_AD_BASE_ERROR_BMODULE);
		}
	}
	
	function validateGroupid()
	{
		$groupid = $this->get('groupid');
		if (!(count($groupid))) {
			$this->addErrorMessage(_AD_BASE_ERROR_GROUPID);
		}
	}
	
	function load(&$obj)
	{
		$this->set('bid', $obj->get('bid'));
		$this->set('title', $obj->get('title'));
		$this->set('side', $obj->get('side'));
		$this->set('weight', $obj->get('weight'));
		$this->set('bcachetime', $obj->get('bcachetime'));
		
		$i = 0;
		foreach ($obj->mBmodule as $module) {
			$this->set('bmodule', $i++, $module->get('module_id'));
		}

		$i = 0;
		foreach ($obj->mGroup as $group) {
			$this->set('groupid', $i++, $group->get('groupid'));
		}
	}

	function update(&$obj)
	{
		$obj->set('bid', $this->get('bid'));
		$obj->set('options', implode('|', $this->get('options')));
		$obj->set('title', $this->get('title'));
		$obj->set('side', $this->get('side'));
		$obj->set('weight', $this->get('weight'));
		$obj->set('bcachetime', $this->get('bcachetime'));

		$obj->set('last_modified', time());
		
		$obj->mBmodule = array();
		$handler =& xoops_getmodulehandler('block_module_link', 'base');
		foreach ($this->get('bmodule') as $mid) {
			$t_obj =& $handler->create();
			$t_obj->set('block_id', $this->get('bid'));
			$t_obj->set('module_id', $mid);
			$obj->mBmodule[] =& $t_obj;
			unset($t_obj);
		}

		$obj->mGroup = array();
		$handler =& xoops_gethandler('group');
		foreach ($this->get('groupid') as $groupid) {
			$obj->mGroup[] =& $handler->get($groupid);
		}
	}
}

?>
