<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/base/class/AbstractFilterForm.class.php";

define('SMILES_SORT_KEY_DEFAULT', 0);
define('SMILES_SORT_KEY_ID', 1);
define('SMILES_SORT_KEY_CODE', 2);
define('SMILES_SORT_KEY_SMILE_URL', 3);
define('SMILES_SORT_KEY_EMOTION', 4);
define('SMILES_SORT_KEY_DISPLAY', 5);
define('SMILES_SORT_KEY_MAXVALUE', 5);

class Legacy_SmilesFilterForm extends Legacy_AbstractFilterForm
{
	var $mSort = 0;
	var $_mSortKeys = array(
		SMILES_SORT_KEY_DEFAULT => 'id',
		SMILES_SORT_KEY_ID => 'id',
		SMILES_SORT_KEY_CODE => 'code',
		SMILES_SORT_KEY_SMILE_URL => 'smile_url',
		SMILES_SORT_KEY_EMOTION => 'emotion',
		SMILES_SORT_KEY_DISPLAY => 'display'
	);
	var $_mCriteria = null;

	function fetch()
	{
		$this->mSort = isset($_REQUEST['sort']) ? intval($_REQUEST['sort']) : 0;
	
		if ($this->mSort > SMILES_SORT_KEY_MAXVALUE) {
			$this->mSort = SMILES_SORT_KEY_DEFAULT;
		}
	
		if (isset($_REQUEST['id'])) {
			$this->_mCriteria->add(new Criteria('id', array(XOBJ_DTYPE_INT, xoops_getrequest('id'))));
		}
	
		if (isset($_REQUEST['code'])) {
			$this->_mCriteria->add(new Criteria('code', array(XOBJ_DTYPE_STRING, xoops_getrequest('code'))));
		}
	
		if (isset($_REQUEST['smile_url'])) {
			$this->_mCriteria->add(new Criteria('smile_url', array(XOBJ_DTYPE_STRING, xoops_getrequest('smile_url'))));
		}
	
		if (isset($_REQUEST['emotion'])) {
			$this->_mCriteria->add(new Criteria('emotion', array(XOBJ_DTYPE_STRING, xoops_getrequest('emotion'))));
		}
	
		if (isset($_REQUEST['display'])) {
			$this->_mCriteria->add(new Criteria('display', array(XOBJ_DTYPE_BOOL, xoops_getrequest('display'))));
		}

		$this->_mCriteria->addSort($this->getSort(), $this->getOrder());
	}
}

?>
