<?php

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * Type:     function
 * Name:     xoops_textarea
 * Version:  1.0
 * Date:     Nov 2, 2005
 * Author:   minahito
 * Purpose:  textarea tag with sanitize.
 * Input:    name = name of form 'name'
 *           value = preset value
 *           class = 
 *           cols = 
 *           rows =
 * 
 * Examples: {xoopsdhtmltarea name=message cols=40 rows=6 value=$message}
 * -------------------------------------------------------------
 */
function smarty_function_xoops_textarea($params, &$smarty)
{
	if(isset($params['name'])) {
		$name = trim($params['name']);
		$class = isset($params['class']) ? trim($params['class']) : null;
		$cols = isset($params['cols']) ? intval($params['cols']) : null;
		$rows = isset($params['rows']) ? intval($params['rows']) : null;
		$value = isset($params['value']) ? htmlspecialchars($params['value'],ENT_QUOTES) : null;
		$id = isset($params['id']) ? trim($params['id']) : null;
		$readonly = isset($params['readonly']) ? trim($params['readonly']) : null;

		$string="<textarea name=\"$name\"";
		if($class)
			$string.=" class=\"$class\"";
		if($cols)
			$string.=" cols=\"$cols\"";
		if($rows)
			$string.=" rows=\"$rows\"";
		if($id)
			$string.=" id=\"$id\"";
		if($readonly==1) {
			$string.=" readonly=\"readonly\"";
		}

		$string.=" />".$value."</textarea>";

		print $string;
	}
}

?>
