<?php

class XCube_TextModifier
{
	function getName()
	{
	}

	function convertString(&$string)
	{
	}

	function convertText(&$text)
	{
	}
}

/**
 * Collect TextModifiers. When a logic wants to call a convert function, this
 * class does substitution.
 */
class XCube_TextModifierManager
{
	var $mDefaultKey=null;
	var $mModifiers=array();

	function addModifier(&$modifier)
	{
		$this->mModifiers[$modifier->getName()]=&$modifier;
		if($this->mDefaultKey==null) {
			$this->mDefaultKey=$modifier->getName();
		}
	}

	function hasModifier($modifierName)
	{
		return array_key_exists($modifierName,$this->mModifiers);
	}
	
	function countModifier()
	{
		return count($this->mModifiers);
	}
	
	function &searchModifier($modifierName=null,$fallback=true)
	{
		$dmy=false;
		if($modifierName!=null) {
			if($this->hasModifier($modifierName)) {
				return $this->mModifiers[$modifierName];
			}
			elseif($fallback) {
				return $this->mModifiers[$this->mDefaultKey];
			}
			else {
				return $dmy;
			}
		}
		else {
			return $this->mModifiers[$this->mDefaultKey];
		}
	}
}

?>