<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/base/class/PageNavigator.class.php";
require_once XOOPS_MODULE_PATH . "/base/class/AbstractListAction.class.php";
require_once XOOPS_MODULE_PATH . "/base/forms/ImageFilterForm.class.php";

class Legacy_ImageListAction extends Legacy_AbstractListAction
{
	var $mImgcatId = null;
	
	function prepare(&$controller, &$xoopsUser)
	{
		$controller->setDialogMode(true);
		
		$root =& $controller->mRoot;
		$root->mLanguageManager->loadModuleLanguage('base');
	}
	
	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('image', 'base');
		return $handler;
	}

	function &_getFilterForm(&$navi)
	{
		$filter =& new Legacy_ImageFilterForm($navi);
		return $filter;
	}

	function _getBaseUrl()
	{
		return XOOPS_URL . "/imagemanager.php?op=list";
	}
	
	function getDefaultView(&$contoller, &$xoopsUser)
	{
		$result = parent::getDefaultView($controller, $xoopsUser);
		if ($result == LEGACY_FRAME_VIEW_INDEX) {
			$this->mImgcatId = xoops_getrequest('imgcat_id');
			$handler =& xoops_getmodulehandler('imagecategory', 'base');
			$this->mCategory =& $handler->get($this->mImgcatId );
		}
		
		return $result;
	}

	function executeViewIndex(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("legacy_image_list.html");
		
		foreach (array_keys($this->mObjects) as $key) {
			$this->mObjects[$key]->loadImagecategory();
		}
		
		$render->setAttribute("objects", $this->mObjects);
		$render->setAttribute("pageNavi", $this->mNavi);
		
		$render->setAttribute('imgcatId', $this->mImgcatId);
		
		$handler =& xoops_getmodulehandler('imagecategory', 'base');
		
		if (is_object($xoopsUser)) {
			$groups =& $xoopsUser->getGroups();
		}
		else {
			$groups = array(XOOPS_GROUP_ANONYMOUS);
		}
		$categoryArr =& $handler->getObjectsWithReadPerm($groups);
		
		$render->setAttribute('categoryArr', $categoryArr);
		
		//
		// If current category object exists, check the permission of uploading.
		//
		$hasUploadPerm = null;
		if ($this->mCategory != null) {
			$hasUploadPerm = $this->mCategory->hasUploadPerm($groups);
		}
		$render->setAttribute('hasUploadPerm', $hasUploadPerm);
		$render->setAttribute("category", $this->mCategory);
		
		$render->setAttribute('target', xoops_getrequest('target'));
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?Action=ImageList");
	}
}

?>
