<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/base/forms/SearchResultsForm.class.php";

class Legacy_SearchResultsAction extends Legacy_Action
{
	var $mActionForm = null;
	var $mSearchResults = array();
	var $mModules = array();
	
	var $mConfig = array();
	
	function prepare(&$controller, &$xoopsUser)
	{
		$root =& $controller->mRoot;
		$root->mLanguageManager->loadModuleLanguage('base');
		
		$handler =& xoops_gethandler('config');
		$this->mConfig =& $handler->getConfigsByCat(XOOPS_CONF_SEARCH);
		
		$this->_setupActionForm();
	}
	
	function _setupActionForm()
	{
		$this->mActionForm =& new Legacy_SearchResultsForm($this->mConfig['keyword_min']);
		$this->mActionForm->prepare();
	}
	
	function hasPerm(&$controller, &$xoopsUser)
	{
		if ($this->mConfig['enable_search'] != 1) {
			XCube_Utils::redirectHeader(XOOPS_URL, 3, _MD_BASE_ERROR_SEARCH_NOT_ENABLED);
			return false;
		}
		return true;
	}
	
	function getDefaultView(&$controller, &$xoopsUser)
	{
		$this->mActionForm->fetch();
		$this->mActionForm->validate();
		
		$this->_makeModuleList($xoopsUser);
		
		if ($this->mActionForm->hasError()) {
			return LEGACY_FRAME_VIEW_INDEX;
		}

		//
		// TODO ErrorHandling
		//
		$root =& $controller->mRoot;
		$service =& $root->mServiceManager->searchXCubeService("LegacySearch");
		if ($service) {
			$client =& new XCube_ServiceClient($service);

			$parameters = array();
			$parameters['current_uid'] = is_object($xoopsUser) ? $xoopsUser->get('uid') : 0;
			
			$this->mActionForm->update($parameters);
			
			$this->mSearchResults = $client->call("getItems", $parameters);
		}
		else {
			return LEGACY_FRAME_VIEW_ERROR;
		}

		return LEGACY_FRAME_VIEW_INDEX;
	}
	
	function _makeModuleList(&$xoopsUser)
	{
		//
		// Make the module list for search form.
		//
		$groups = is_object($xoopsUser) ? $xoopsUser->getGroups() : XOOPS_GROUP_ANONYMOUS;
		$handler = & xoops_gethandler( 'groupperm' );
		$mids = $handler->getItemIds('module_read', $groups);
		
		$handler =& xoops_gethandler('module');
		foreach ($mids as $mid) {
			$module =& $handler->get($mid);
			if ($module->get('isactive') && $module->get('hassearch')) {
				$this->mModules[] =& $module;
			}
			unset($module);
		}
	}
	
	function execute(&$controller, &$xoopsUser)
	{
		return $this->getDefaultView($controller, $xoopsUser);
	}
	
	function executeViewIndex(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName($this->_getTemplateName());
	
		$render->setAttribute('actionForm', $this->mActionForm);
			
		$render->setAttribute('searchResults', $this->mSearchResults);
		$render->setAttribute('moduleArr', $this->mModules);

		//
		// If the request include $mids, setAttribute it. If it don't include, 
		// setAttribute $mid or $this->mModules.
		//		
		$render->setAttribute('selectedMidArr', $this->_getSelectedMids());
		$render->setAttribute('searchRuleMessage', @sprintf(_SR_KEYTOOSHORT, $this->mConfig['keyword_min']));
	}
	
	function _getTemplateName()
	{
		return "legacy_search_results.html";
	}
	
	function _getSelectedMids()
	{
		$ret = $this->mActionForm->get('mids');
		if (!count($ret)) {
			foreach ($this->mModules as $module) {
				$ret[] = $module->get('mid');
			}
		}
		
		return $ret;
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward(XOOPS_URL);
	}
}

?>
