<?php
/**
 * @version $Id: HelpAction.class.php,v 1.1.2.6 2006/05/24 13:54:37 minahito Exp $
 */

 if (!defined('XOOPS_ROOT_PATH')) exit();

/**
 * This class extends Smarty to mediate the collision compiled file name.
 */
class Legacy_HelpSmarty extends Smarty
{
	var $mDirname = null;
	var $mModuleObject = null;
	var $mFilename = null;

	function Legacy_HelpSmarty()
	{
		parent::Smarty();

		$this->compile_id = null;
		$this->_canUpdateFromFile = true;
		$this->compile_check = true;
		$this->compile_dir = XOOPS_COMPILE_PATH;
		$this->left_delimiter = "<{";
		$this->right_delimiter = "}>";
		
		$this->force_compile = true;

		$this->register_modifier("helpurl", "Legacy_modifier_helpurl");
		$this->register_modifier("helpimage", "Legacy_modifier_helpimage");
	}
	
	function setDirname($dirname)
	{
		$this->mDirname = $dirname;
	}

	function _get_auto_filename($autoBase, $autoSource = null, $auotId = null)
	{
		$autoSource = $this->mDirname . "_help_" . $autoSource;
		return parent::_get_auto_filename($autoBase, $autoSource, $auotId);
	}
}

function Legacy_modifier_helpurl($file)
{
	$root =& XCube_Root::getSingleton();
	$modController =& $root->mController->getModuleController();
	$moduleObject =& $modController->getXoopsModule();
	
	$language = $root->mController->getConfig('language');
	$dirname = $moduleObject->getVar('dirname');

	//
	// TODO We should check file_exists.
	//

	$url = XOOPS_MODULE_URL . "/base/admin/index.php?action=Help&amp;dirname=${dirname}&amp;file=${file}";

	return $url;
}

function Legacy_modifier_helpimage($file)
{
	$root =& XCube_Root::getSingleton();
	$modController =& $root->mController->getModuleController();
	$moduleObject =& $modController->getXoopsModule();
	
	$language = $root->mController->getConfig('language');
	$dirname = $moduleObject->getVar('dirname');

	$url = XOOPS_MODULE_URL . "/${dirname}/language/${language}/helpimages/${file}";
	if (!file_exists($url) && $language != "english") {
		$url = XOOPS_MODULE_URL . "/${dirname}/language/english/helpimages/${file}";
	}

	return $url;
}

/**
 * This action will show the information of a module specified to user.
 */
class Legacy_HelpAction extends Legacy_Action
{
	var $mModuleObject = null;
	var $mContents = null;

	var $mErrorMessage = null;
	
	/**
	 * @access private
	 */
	var $_mDirname = null;
	
	function hasPerm(&$controller, &$xoopsUser)
	{
		$this->_mDirname = xoops_getrequest('dirname');
		
		$moduleHandler =& xoops_gethandler('module');
		$permHandler =& xoops_gethandler('groupperm');
		
		$module =& $moduleHandler->getByDirname($this->_mDirname);
		
		return $permHandler->checkRight('module_admin', $module->get('mid'), $xoopsUser->getGroups());
	}
	
	function getDefaultView(&$controller, &$xoopsUser)
	{
		$moduleHandler =& xoops_gethandler('module');
		$this->mModuleObject =& $moduleHandler->getByDirname($this->_mDirname);
		
		$language =& $controller->getConfig('language');

		//
		// TODO We must change the following lines to ActionForm.
		//
		$helpfile = xoops_getrequest('file') ? xoops_getrequest('file') : $this->mModuleObject->getHelp();

		//
		// Smarty
		//
		$smarty =& new Legacy_HelpSmarty();
		$smarty->setDirname($this->_mDirname);

		//
		// file check
		//
		$template_dir = XOOPS_MODULE_PATH . "/" . $this->_mDirname . "/language/" . $language;
		if (!file_exists($template_dir . "/" . $helpfile)) {
			$template_dir = XOOPS_MODULE_PATH . "/" . $this->_mDirname . "/language/english";
			if (!file_exists($template_dir . "/" . $helpfile)) {
				$this->mErrorMessage = _MD_A_BASE_ERROR_NO_HELP_FILE;
				return LEGACY_FRAME_VIEW_ERROR;
			}
		}

		$smarty->template_dir = $template_dir;
		$this->mContents = $smarty->fetch("file:" . $helpfile);

		return LEGACY_FRAME_VIEW_SUCCESS;
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$renderer)
	{
		$renderer->setTemplateName("help.html");
		$renderer->setAttribute('module', $this->mModuleObject);
		$renderer->setAttribute('contents', $this->mContents);
	}

	function executeViewError(&$controller, &$xoopsUser, &$renderer)
	{
		XCube_Utils::redirectHeader('./index.php?action=ModuleList', 1, $this->mErrorMessage);
	}
}

?>