<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/base/class/AbstractFilterForm.class.php";

define('NEWBLOCKS_SORT_KEY_BID', 1);
define('NEWBLOCKS_SORT_KEY_MID', 2);
define('NEWBLOCKS_SORT_KEY_FUNC_NUM', 3);
define('NEWBLOCKS_SORT_KEY_OPTIONS', 4);
define('NEWBLOCKS_SORT_KEY_NAME', 5);
define('NEWBLOCKS_SORT_KEY_TITLE', 6);
define('NEWBLOCKS_SORT_KEY_CONTENT', 7);
define('NEWBLOCKS_SORT_KEY_SIDE', 8);
define('NEWBLOCKS_SORT_KEY_WEIGHT', 9);
define('NEWBLOCKS_SORT_KEY_VISIBLE', 10);
define('NEWBLOCKS_SORT_KEY_BLOCK_TYPE', 11);
define('NEWBLOCKS_SORT_KEY_C_TYPE', 12);
define('NEWBLOCKS_SORT_KEY_ISACTIVE', 13);
define('NEWBLOCKS_SORT_KEY_DIRNAME', 14);
define('NEWBLOCKS_SORT_KEY_FUNC_FILE', 15);
define('NEWBLOCKS_SORT_KEY_SHOW_FUNC', 16);
define('NEWBLOCKS_SORT_KEY_EDIT_FUNC', 17);
define('NEWBLOCKS_SORT_KEY_TEMPLATE', 18);
define('NEWBLOCKS_SORT_KEY_BCACHETIME', 19);
define('NEWBLOCKS_SORT_KEY_LAST_MODIFIED', 20);
define('NEWBLOCKS_SORT_KEY_MAXVALUE', 20);

define('NEWBLOCKS_SORT_KEY_DEFAULT', NEWBLOCKS_SORT_KEY_MID);

//
// TODO This class should extend Legacy_BlockFilterForm
//
class Legacy_BlockInstallFilterForm extends Legacy_AbstractFilterForm
{
	var $mSort = 0;
	var $_mSortKeys = array(
		NEWBLOCKS_SORT_KEY_BID => 'bid',
		NEWBLOCKS_SORT_KEY_MID => 'mid',
		NEWBLOCKS_SORT_KEY_FUNC_NUM => 'func_num',
		NEWBLOCKS_SORT_KEY_OPTIONS => 'options',
		NEWBLOCKS_SORT_KEY_NAME => 'name',
		NEWBLOCKS_SORT_KEY_TITLE => 'title',
		NEWBLOCKS_SORT_KEY_CONTENT => 'content',
		NEWBLOCKS_SORT_KEY_SIDE => 'side',
		NEWBLOCKS_SORT_KEY_WEIGHT => 'weight',
		NEWBLOCKS_SORT_KEY_VISIBLE => 'visible',
		NEWBLOCKS_SORT_KEY_BLOCK_TYPE => 'block_type',
		NEWBLOCKS_SORT_KEY_C_TYPE => 'c_type',
		NEWBLOCKS_SORT_KEY_ISACTIVE => 'isactive',
		NEWBLOCKS_SORT_KEY_DIRNAME => 'dirname',
		NEWBLOCKS_SORT_KEY_FUNC_FILE => 'func_file',
		NEWBLOCKS_SORT_KEY_SHOW_FUNC => 'show_func',
		NEWBLOCKS_SORT_KEY_EDIT_FUNC => 'edit_func',
		NEWBLOCKS_SORT_KEY_TEMPLATE => 'template',
		NEWBLOCKS_SORT_KEY_BCACHETIME => 'bcachetime',
		NEWBLOCKS_SORT_KEY_LAST_MODIFIED => 'last_modified'
	);
	var $_mCriteria = null;

	function fetch()
	{
		$this->mSort = isset($_REQUEST['sort']) ? intval($_REQUEST['sort']) : NEWBLOCKS_SORT_KEY_DEFAULT;
	
		if ($this->mSort > NEWBLOCKS_SORT_KEY_MAXVALUE) {
			$this->mSort = NEWBLOCKS_SORT_KEY_DEFAULT;
		}
	
		if (isset($_REQUEST['mid'])) {
			$this->_mNavi->addExtra('mid', xoops_getrequest('mid'));
			$this->_mCriteria->add(new Criteria('mid', array(XOBJ_DTYPE_INT, xoops_getrequest('mid'))));
		}
	
		if (isset($_REQUEST['name'])) {
			$this->_mNavi->addExtra('name', xoops_getrequest('name'));
			$this->_mCriteria->add(new Criteria('name', array(XOBJ_DTYPE_STRING, xoops_getrequest('name'))));
		}
	
		if (isset($_REQUEST['title'])) {
			$this->_mNavi->addExtra('title', xoops_getrequest('title'));
			$this->_mCriteria->add(new Criteria('title', array(XOBJ_DTYPE_STRING, xoops_getrequest('title'))));
		}
	
		if (isset($_REQUEST['dirname'])) {
			$this->_mNavi->addExtra('dirname', xoops_getrequest('dirname'));
			$this->_mCriteria->add(new Criteria('dirname', array(XOBJ_DTYPE_STRING, xoops_getrequest('dirname'))));
		}

		$this->_mNavi->addExtra('sort', $this->mSort);

		$this->_mCriteria->add(new Criteria('visible', array(XOBJ_DTYPE_BOOL, 0)));
		$this->_mCriteria->add(new Criteria('isactive', array(XOBJ_DTYPE_BOOL, 1)));

		$this->_mCriteria->addSort($this->getSort(), $this->getOrder());
		
		//
		// If the sort key is mid, set c_type to second sort key for list display.
		//
		if (abs($this->mSort) == NEWBLOCKS_SORT_KEY_MID) {
			$this->_mCriteria->addSort('c_type', $this->getOrder());
		}
		
		if (abs($this->mSort) != NEWBLOCKS_SORT_KEY_SIDE) {
			$this->_mCriteria->addSort('side', $this->getOrder());
		}
		
		if (abs($this->mSort) != NEWBLOCKS_SORT_KEY_WEIGHT) {
			$this->_mCriteria->addSort('weight', $this->getOrder());
		}
	}
}

?>
