<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/base/class/AbstractFilterForm.class.php";

define('IMAGE_SORT_KEY_IMAGE_ID', 1);
define('IMAGE_SORT_KEY_IMAGE_NAME', 2);
define('IMAGE_SORT_KEY_IMAGE_NICENAME', 3);
define('IMAGE_SORT_KEY_IMAGE_MIMETYPE', 4);
define('IMAGE_SORT_KEY_IMAGE_CREATED', 5);
define('IMAGE_SORT_KEY_IMAGE_DISPLAY', 6);
define('IMAGE_SORT_KEY_IMAGE_WEIGHT', 7);
define('IMAGE_SORT_KEY_IMGCAT_ID', 8);
define('IMAGE_SORT_KEY_MAXVALUE', 8);

define('IMAGE_SORT_KEY_DEFAULT', IMAGE_SORT_KEY_IMAGE_WEIGHT);

class Legacy_ImageFilterForm extends Legacy_AbstractFilterForm
{
	var $mSort = 0;
	var $_mSortKeys = array(
		IMAGE_SORT_KEY_IMAGE_ID => 'image_id',
		IMAGE_SORT_KEY_IMAGE_NAME => 'image_name',
		IMAGE_SORT_KEY_IMAGE_NICENAME => 'image_nicename',
		IMAGE_SORT_KEY_IMAGE_MIMETYPE => 'image_mimetype',
		IMAGE_SORT_KEY_IMAGE_CREATED => 'image_created',
		IMAGE_SORT_KEY_IMAGE_DISPLAY => 'image_display',
		IMAGE_SORT_KEY_IMAGE_WEIGHT => 'image_weight',
		IMAGE_SORT_KEY_IMGCAT_ID => 'imgcat_id'
	);
	var $_mCriteria = null;

	function fetch()
	{
		$this->mSort = isset($_REQUEST['sort']) ? intval($_REQUEST['sort']) : IMAGE_SORT_KEY_DEFAULT;
	
		if ($this->mSort > IMAGE_SORT_KEY_MAXVALUE) {
			$this->mSort = IMAGE_SORT_KEY_DEFAULT;
		}
	
//		if (isset($_REQUEST['image_name'])) {
//			$this->_mNavi->addExtra('image_name', xoops_getrequest('image_name'));
//			$this->_mCriteria->add(new Criteria('image_name', array(XOBJ_DTYPE_STRING, xoops_getrequest('image_name'))));
//		}
	
//		if (isset($_REQUEST['image_nicename'])) {
//			$this->_mNavi->addExtra('image_nicename', xoops_getrequest('image_nicename'));
//			$this->_mCriteria->add(new Criteria('image_nicename', array(XOBJ_DTYPE_STRING, xoops_getrequest('image_nicename'))));
//		}
	
		if (isset($_REQUEST['image_display'])) {
			$this->_mNavi->addExtra('image_display', xoops_getrequest('image_display'));
			$this->_mCriteria->add(new Criteria('image_display', array(XOBJ_DTYPE_BOOL, xoops_getrequest('image_display'))));
		}
	
		if (isset($_REQUEST['imgcat_id'])) {
			$this->_mNavi->addExtra('imgcat_id', xoops_getrequest('imgcat_id'));
			$this->_mCriteria->add(new Criteria('imgcat_id', array(XOBJ_DTYPE_INT, xoops_getrequest('imgcat_id'))));
		}
		
		$this->_mCriteria->addSort($this->getSort(), $this->getOrder());
		if (abs($this->mSort) != IMAGE_SORT_KEY_IMAGE_WEIGHT) {
			$this->_mCriteria->addSort(IMAGE_SORT_KEY_IMAGE_WEIGHT, $this->getOrder());
		}
	}
}

?>
