<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH."/kernel/XCube_Module.class.php";

/**
 * This is adapter for XCube_Module by XoopsModule.
 */
class Legacy_ModuleAdapter extends XCube_Module
{
	var $mAdaptee;

	function Legacy_ModuleAdapter(&$xoopsModule)
	{
		$this->mAdaptee=&$xoopsModule;
	}

	function prepareAdmin(&$controller)
	{
		$this->mAdaptee->loadAdminMenu();
		if(count($this->mAdaptee->adminmenu)>0 || isset($this->mAdaptee->modinfo['config']) ) {
			$delegate=new XCube_InstanceDelegate($this,"callbackSearchAction");
			$controller->mRoot->mEventManager->add("Module.Admin.ActionSearch",$delegate);
		}
	}

	function callbackSearchAction(&$sender,&$eventArgs)
	{
		if(!is_object($eventArgs))
			return;
			
		//
		// Search preference
		//
		if(isset($this->mAdaptee->modinfo['config'])&&count($this->mAdaptee->modinfo['config'])>0) {
			$configInfos=array();
			foreach($this->mAdaptee->modinfo['config'] as $config) {
				if(isset($config['title']))
					$configInfos[]=@constant($config['title']);
				if(isset($config['description']))
					$configInfos[]=@constant($config['description']);
				if(isset($config['options'])&&count($config['options'])>0) {
					foreach($config['options'] as $key=>$val) {
						$configInfos[]=$key;
					}
				}
			}

			$findFlag=true;
			foreach($eventArgs->getKeywords() as $word) {
				$findFlag&=(stristr(implode(" ",$configInfos),$word)!==false);
			}
				
			if($findFlag) {
				$eventArgs->addRecord($this->mAdaptee->getVar('name'),
				                  XOOPS_URL.'/modules/base/admin/index.php?action=PreferenceEdit&amp;confmod_id='.$this->mAdaptee->getVar('mid'),
				                  _PREFERENCES );
			}
		}
		
		//
		// Search AdminMenu
		//
		if(count($this->mAdaptee->adminmenu)>0) {
			foreach($this->mAdaptee->adminmenu as $menu) {
				$findFlag=true;
				foreach($eventArgs->getKeywords() as $word) {
					$tmpFlag=false;
					$tmpFlag|=(stristr($menu['title'],$word)!==false);

					// Search keyword
					if(isset($menu['keywords'])) {
						$keyword=is_array($menu['keywords']) ? implode(" ",$menu['keywords']) : $menu['keywords'];
						$tmpFlag|=(stristr($keyword,$word)!==false);
					}

					$findFlag&=$tmpFlag;
				}

				if($findFlag) {
					//
					// Create url string with absolute information.
					//
					$url="";
					if(isset($menu['absolute'])&&$menu['absolute']) {
						$url=$menu['link'];
					}
					else {
						$url=XOOPS_URL."/modules/".$this->mAdaptee->getVar('dirname')."/".$menu['link'];
					}

					//
					// Add record
					//
					$eventArgs->addRecord($this->mAdaptee->getVar('name'),$url,$menu['title']);
				}
			}
		}
		
		//
		// Search help
		//
		if ($this->mAdaptee->hasHelp()) {
			$root =& XCube_Root::getSingleton();
			$language = $root->mController->getConfig('language');
			$helpfile = $this->mAdaptee->getHelp();
			$dir = XOOPS_MODULE_PATH . "/" . $this->mAdaptee->getVar('dirname') . "/language/" . $language;

			if (!file_exists($dir . "/" . $helpfile)) {
				$dir = XOOPS_MODULE_PATH . "/" . $this->mAdaptee->getVar('dirname') . "/language/" . $language;
					if (!file_exists($dir . "/" . $helpfile)) {
						return;
					}
			}
			$lines = file($dir . "/" . $helpfile);
			foreach ($lines as $line) {
				foreach($eventArgs->getKeywords() as $word) {
					if (stristr($line, $word) !== false) {
						$url = XOOPS_MODULE_URL . "/base/admin/index.php?action=Help&amp;dirname=" . $this->mAdaptee->getVar('dirname');
						$eventArgs->addRecord($this->mAdaptee->getVar('name'), $url, _HELP);
						return;
					}
				}
			}
		}
	}
}

?>