<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

class BaseImagebodyObject extends XoopsSimpleObject
{
	var $mImageBody = null;
	var $_mImageBodyLoadedFlag = false;

	function BaseImagebodyObject()
	{
		$this->initVar('image_id', XOBJ_DTYPE_INT, '', false);
		$this->initVar('image_body', XOBJ_DTYPE_TEXT, '', true);
	}

	function loadImagebody()
	{
		if ($this->_mImageBodyLoadedFlag == false) {
			$handler =& xoops_getmodulehandler('imagebody', 'base');
			$this->mImageBody =& $handler->get($this->get('image_id'));
			$this->_mImageBodyLoadedFlag = true;
		}
	}

	function &createImagebody()
	{
		$handler =& xoops_getmodulehandler('imagebody', 'base');
		$obj =& $handler->create();
		$obj->set('image_id', $this->get('image_id'));
		return $obj;
	}
}

class BaseImagebodyHandler extends XoopsObjectGenericHandler
{
	var $mTable = "imagebody";
	var $mPrimary = "image_id";
	var $mClass = "BaseImagebodyObject";
	
	function insert(&$obj, $force = false)
	{
		if (!parent::insert($obj, $force)) {
			print_r($this->db);
			die();
		}
		
		return true;
	}

	function delete(&$obj, $force = false)
	{
		$handler =& xoops_getmodulehandler('imagebody', 'base');
		$handler->delete($obj->get('image_id'));
		unset($handler);
	
		return parent::delete($obj, $force);
	}
}

?>
