<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH."/class/XCube_Service.class.php";

/**
 * Sample class
 */
class LegacySearchService extends XCube_Service
{
	/**
	 * @param $parameters['uid'] Target user's id
	 * @param $parameters['current_uid'] Current user's id
	 * @param $parameters['maxhit'] Max hit count of each modules. The default value is 5.
	 * @param $parameters['mid'] If this is specified, search only one module.
	 */
	function doGetItems(&$parameters)
	{
		$ret = array();
		$uid = isset($parameters['uid']) ? intval($parameters['uid']) : 0;
		$queries = isset($parameters['queries']) ? $parameters['queries'] : null;

		$andor = isset($parameters['andor']) ? $parameters['andor'] : null;
		if ($andor == null) {
			$andor == "AND";
		}
		
		$maxhit = isset($parameters['maxhit']) ? intval($parameters['maxhit']) : 5;
		$start = isset($parameters['offset']) ? intval($parameters['offset']) : null;
		
		$userHandler =& xoops_gethandler('user');
		$currentUser =& $userHandler->get($parameters['current_uid']);
		
		$gpermHandler = & xoops_gethandler( 'groupperm' );
		$groups = is_object($currentUser) ? $currentUser->getGroups() : XOOPS_GROUP_ANONYMOUS;

		//
		// At first, get active module IDs.
		//
		$moduleHandler =& xoops_gethandler('module');
		
		$mids = array();
		if (isset($parameters['mids']) && is_array($parameters['mids'])) {
			$mids = $parameters['mids'];
		}
		elseif (isset($parameters['mid'])) {
			$mids[] = intval($parameters['mid']);
		}
		else {
			$criteria =& new CriteriaCompo(new Criteria('hassearch', 1));
			$criteria->add(new Criteria('isactive', 1));
			$mids =& array_keys($moduleHandler->getList($criteria));
		}

		//
		// Next, fetch from $mids[], and check read permission.
		// If user can read the module information, execute search.
		//
		$root =& XCube_Root::getSingleton();
		$timezone = $root->mController->getConfig('server_TZ') * 3600;
		
		$i = 0;
		foreach ($mids as $mid) {
			if ($gpermHandler->checkRight('module_read', $mid, $groups)) {
				$module =& $moduleHandler->get($mid);
				if (!is_object($module)) {
					continue;
				}
				
				$results =& $module->search($queries, $andor, $maxhit, $start, $uid);
				
				$ret[$i]['mid'] = $mid;
				$ret[$i]['name'] = $module->get('name');
				
				if (is_array($results) && count($results) > 0) {
					foreach ($results as $result) {
						$item = array();
						if (isset($result['image']) && strlen($result['image']) > 0) {
							$item['image'] = XOOPS_URL . '/modules/' . $module->getVar('dirname') . '/' . $result['image'];
						}
						else {
							$item['image'] = XOOPS_URL . '/images/icons/posticon2.gif';
						}
						
						$item['link'] = XOOPS_URL . '/modules/' . $module->getVar('dirname') . '/' . $result['link'];
						$item['title'] = $result['title'];
						$item['uid'] = $result['uid'];
						
						//
						// TODO If this service will come to web service, we should
						// change format from unixtime to string by timeoffset.
						//
						$item['time'] = isset($result['time']) ? $result['time'] - $timezone : 0;
						
						$ret[$i]['results'][] = $item;
					}
					
					$ret[$i]['has_more'] = (count($results) == $maxhit);
				}
				else {
					$ret[$i]['results'] = array();
					$ret[$i]['showall_link'] = "";
				}
			}
		}
		
		return $ret;
	}
}

?>