<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/legacyRender/admin/class/AbstractListAction.class.php";
require_once XOOPS_MODULE_PATH . "/legacyRender/admin/forms/TplfileFilterForm.class.php";
require_once XOOPS_MODULE_PATH . "/legacyRender/admin/forms/TplfileSetFilterForm.class.php";

require_once XOOPS_MODULE_PATH . "/legacyRender/admin/forms/TplfileUploadForm.class.php";

class LegacyRender_TplfileListAction extends LegacyRender_AbstractListAction
{
	var $mActionForm = null;
	
	function prepare(&$controller, &$xoopsUser)
	{
		$this->mActionForm =& new LegacyRender_TplfileUploadForm();
		$this->mActionForm->prepare();
	}
	
	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('tplfile');
		return $handler;
	}

	function &_getFilterForm()
	{
		$filter = isset($_REQUEST['tpl_tplset']) ? new LegacyRender_TplfileSetFilterForm($this->mPageNavi) : new LegacyRender_TplfileFilterForm($this->mPageNavi);
		return $filter;
	}
	
	function _getBaseUrl()
	{
		return "./index.php?action=TplfileList";
	}

	function getDefaultView(&$controller, &$xoopsUser)
	{
		$this->mPageNavi =& new LegacyRender_PageNavigator($this->_getBaseUrl(), 0, XCUBE_PAGENAVI_START | XCUBE_PAGENAVI_PERPAGE);

		$this->mFilter =& $this->_getFilterForm();
		$this->mFilter->fetch();
	
		$handler =& $this->_getHandler();
	
		$total = $handler->getCount($this->mFilter->getCriteria());
		
		$this->mPageNavi->setTotal($total);
		$this->mPageNavi->fetch();
		
		$criteria = $this->mFilter->getCriteria($this->mPageNavi->getStart(), $this->mPageNavi->getPerpage());
		
		if (isset($_REQUEST['tpl_tplset'])) {
			$this->mObjects =& $handler->getObjectsWithOverride($criteria, xoops_getrequest('tpl_tplset'));
		}
		else {
			$this->mObjects =& $handler->getObjects($criteria);
		}
	
		return LEGACYRENDER_FRAME_VIEW_INDEX;
	}

	function execute(&$controller, &$xoopsUser)
	{
		require_once XOOPS_ROOT_PATH . "/class/template.php";
		
		$this->mActionForm->fetch();
		$this->mActionForm->validate();
		
		if ($this->mActionForm->hasError()) {
			return $this->getDefaultView($controller, $xoopsUser);
		}
		
		$formFileArr = $this->mActionForm->get('upload');

		//
		// Set tpl_module and tpl_tplset of the last object to the following variable for redirect.
		//
		$last_tplset = null;
		$last_module = null;
		
		$handler =& xoops_getmodulehandler('tplfile');		
		
		$successFlag = true;
		
		foreach (array_keys($formFileArr) as $key) {
			$formFile =& $formFileArr[$key];
			
			$obj =& $handler->get($key);
			if ($obj == null) {
				continue;
			}

			//
			// If $obj belongs to 'default' template-set, kick!
			//			
			if ($obj->get('tpl_tplset') == 'default') {
				continue;
			}

			$obj->loadSource();
			
			$last_tplset = $obj->getVar('tpl_tplset');
			$last_module = $obj->getVar('tpl_module');
			
			//
			// [Warning] Access to a private property of XCube_FormFile.
			//
			$source = file_get_contents($formFile->_mTmpFileName);
			$obj->Source->set('tpl_source', $source);
			$obj->set('tpl_lastmodified', time());
			$obj->set('tpl_lastimported', time());
			
			$successFlag &= $handler->insert($obj);
			
			$xoopsTpl =& new XoopsTpl();
			$xoopsTpl->clear_cache('db:' . $obj->get('tpl_file'));
			$xoopsTpl->clear_compiled_tpl('db:' . $obj->get('tpl_file'));
		
			unset($obj);
			unset($formFile);
		}
		
		$errorMessage = $successFlag ? _AD_LEGACYRENDER_MESSAGE_UPLOAD_TEMPLATE_SUCCESS : _AD_LEGACYRENDER_ERROR_DBUPDATE_FAILED;
		
		XCube_Utils::redirectHeader("index.php?action=TplfileList&amp;tpl_tplset=${last_tplset}&amp;tpl_module=${last_module}",	1, $errorMessage);
	}

	function executeViewIndex(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("tplfile_list.html");
		
		//
		// Load override file.
		//
		if ($this->mFilter->mTplset != null && $this->mFilter->mTplset->get('tplset_name') != 'default') {
			foreach (array_keys($this->mObjects) as $key) {
				$this->mObjects[$key]->loadOverride($this->mFilter->mTplset->get('tplset_name'));
			}
		}
		
		$render->setAttribute('objects', $this->mObjects);
		$render->setAttribute('pageNavi', $this->mPageNavi);
		$render->setAttribute('filterForm', $this->mFilter);
		$render->setAttribute('actionForm', $this->mActionForm);
		
		if ($this->mFilter->mTplset != null) {
			$render->setAttribute('targetTplset', $this->mFilter->mTplset->get('tplset_name'));
		}
		
		$render->setAttribute('targetModule', xoops_getrequest('tpl_module'));
		
		//
		// TODO We must fetch only module objects that has templates.
		// 
		// fetch module objects, assign to template for pull-down menu.
		//
		$moduleHandler =& xoops_gethandler('module');
		$modules =& $moduleHandler->getObjects();
		$render->setAttribute('modules', $modules);

		$handler =& xoops_getmodulehandler('tplset');
		$tplsets =& $handler->getObjects();
		$render->setAttribute('tplsets', $tplsets);
	}
}

?>
